/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import akka.actor.ActorRef;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.pattern.Patterns;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.internal.utils.akka.logging.DittoLoggerFactory;
import org.eclipse.ditto.internal.utils.akka.logging.ThreadSafeDittoLogger;
import org.eclipse.ditto.internal.utils.cache.CacheKey;
import org.eclipse.ditto.internal.utils.cache.CacheLookupContext;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;
import org.eclipse.ditto.internal.utils.cacheloaders.EntityRegionMap;

@Immutable
public final class ActorAskCacheLoader<V, T>
implements AsyncCacheLoader<CacheKey, Entry<V>> {
    private static final ThreadSafeDittoLogger LOGGER = DittoLoggerFactory.getThreadSafeLogger(ActorAskCacheLoader.class);
    private final Duration askTimeout;
    private final Function<EntityType, ActorRef> entityRegionProvider;
    private final Map<EntityType, BiFunction<EntityId, CacheLookupContext, T>> commandCreatorMap;
    private final Map<EntityType, BiFunction<Object, CacheLookupContext, Entry<V>>> responseTransformerMap;

    private ActorAskCacheLoader(Duration askTimeout, Function<EntityType, ActorRef> entityRegionProvider, Map<EntityType, BiFunction<EntityId, CacheLookupContext, T>> commandCreatorMap, Map<EntityType, BiFunction<Object, CacheLookupContext, Entry<V>>> responseTransformerMap) {
        this.askTimeout = Objects.requireNonNull(askTimeout);
        this.entityRegionProvider = Objects.requireNonNull(entityRegionProvider);
        this.commandCreatorMap = Map.copyOf(Objects.requireNonNull(commandCreatorMap));
        this.responseTransformerMap = Map.copyOf(Objects.requireNonNull(responseTransformerMap));
    }

    public static <V> ActorAskCacheLoader<V, Command<?>> forShard(Duration askTimeout, Function<EntityType, ActorRef> entityRegionProvider, Map<EntityType, BiFunction<EntityId, CacheLookupContext, Command<?>>> commandCreatorMap, Map<EntityType, BiFunction<Object, CacheLookupContext, Entry<V>>> responseTransformerMap) {
        return new ActorAskCacheLoader(askTimeout, entityRegionProvider, commandCreatorMap, responseTransformerMap);
    }

    public static <V> ActorAskCacheLoader<V, Command<?>> forShard(Duration askTimeout, EntityType entityType, ActorRef entityRegion, BiFunction<EntityId, CacheLookupContext, Command<?>> commandCreator, BiFunction<Object, CacheLookupContext, Entry<V>> responseTransformer) {
        Objects.requireNonNull(askTimeout);
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(entityRegion);
        Objects.requireNonNull(commandCreator);
        Objects.requireNonNull(responseTransformer);
        return ActorAskCacheLoader.forShard(askTimeout, EntityRegionMap.singleton(entityType, entityRegion), Collections.singletonMap(entityType, commandCreator), Collections.singletonMap(entityType, responseTransformer));
    }

    public static <V> ActorAskCacheLoader<V, DistributedPubSubMediator.Send> forPubSub(Duration askTimeout, ActorRef pubSubMediator, Map<EntityType, BiFunction<EntityId, CacheLookupContext, DistributedPubSubMediator.Send>> commandCreatorMap, Map<EntityType, BiFunction<Object, CacheLookupContext, Entry<V>>> responseTransformerMap) {
        return new ActorAskCacheLoader(askTimeout, unused -> pubSubMediator, commandCreatorMap, responseTransformerMap);
    }

    public static <V> ActorAskCacheLoader<V, DistributedPubSubMediator.Send> forPubSub(Duration askTimeout, EntityType entityType, ActorRef pubSubMediator, BiFunction<EntityId, CacheLookupContext, DistributedPubSubMediator.Send> commandCreator, BiFunction<Object, CacheLookupContext, Entry<V>> responseTransformer) {
        Objects.requireNonNull(askTimeout);
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(pubSubMediator);
        Objects.requireNonNull(commandCreator);
        Objects.requireNonNull(responseTransformer);
        return ActorAskCacheLoader.forPubSub(askTimeout, pubSubMediator, Collections.singletonMap(entityType, commandCreator), Collections.singletonMap(entityType, responseTransformer));
    }

    public final CompletableFuture<Entry<V>> asyncLoad(CacheKey key, Executor executor) {
        EntityType entityType = key.getId().getEntityType();
        return CompletableFuture.supplyAsync(() -> {
            EntityId entityId = key.getId();
            return this.getCommand(entityType, entityId, key.getCacheLookupContext().orElse(null));
        }, executor).thenCompose(command -> {
            ActorRef entityRegion = this.getEntityRegion(entityType);
            LOGGER.debug("Going to retrieve cache entry for key <{}> with command <{}>: ", (Object)key, command);
            return Patterns.ask((ActorRef)entityRegion, (Object)command, (Duration)this.askTimeout).thenApply(response -> this.transformResponse(entityType, response, key.getCacheLookupContext().orElse(null))).toCompletableFuture();
        });
    }

    private ActorRef getEntityRegion(EntityType entityType) {
        ActorRef entityRegion = this.entityRegionProvider.apply(entityType);
        if (entityRegion == null) {
            throw new IllegalStateException("null entity region returned for resource type " + entityType);
        }
        return entityRegion;
    }

    private T getCommand(EntityType entityType, EntityId id, @Nullable CacheLookupContext cacheLookupContext) {
        BiFunction<EntityId, CacheLookupContext, EntityId> commandCreator = this.commandCreatorMap.get(entityType);
        if (commandCreator == null) {
            String message = String.format("Don't know how to create retrieve command for resource type <%s> and id <%s>", entityType, id);
            throw new NullPointerException(message);
        }
        return commandCreator.apply(id, cacheLookupContext);
    }

    private Entry<V> transformResponse(EntityType entityType, Object response, @Nullable CacheLookupContext cacheLookupContext) {
        return (Entry)((BiFunction)ConditionChecker.checkNotNull(this.responseTransformerMap.get(entityType), (String)"entityType")).apply(response, cacheLookupContext);
    }
}

