/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import akka.actor.ActorRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.entity.type.EntityType;

@Immutable
public final class EntityRegionMap
implements Function<EntityType, ActorRef> {
    private final Map<EntityType, ActorRef> rawMap;

    private EntityRegionMap(Map<EntityType, ActorRef> rawMap) {
        this.rawMap = Collections.unmodifiableMap(new HashMap<EntityType, ActorRef>(rawMap));
    }

    private EntityRegionMap(Builder builder) {
        this(builder.hashMap);
    }

    public Optional<ActorRef> lookup(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return Optional.ofNullable(this.findRegion(entityType));
    }

    @Nullable
    private ActorRef findRegion(EntityType entityType) {
        return this.rawMap.get(entityType);
    }

    @Override
    @Nullable
    public ActorRef apply(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return this.findRegion(entityType);
    }

    public static EntityRegionMap singleton(EntityType entityType, ActorRef targetActor) {
        return new EntityRegionMap(Collections.singletonMap(entityType, targetActor));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityRegionMap that = (EntityRegionMap)o;
        return Objects.equals(this.rawMap, that.rawMap);
    }

    public int hashCode() {
        return Objects.hash(this.rawMap);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [rawMap=" + this.rawMap + "]";
    }

    @NotThreadSafe
    public static final class Builder {
        private final HashMap<EntityType, ActorRef> hashMap = new HashMap();

        public Builder put(EntityType entityType, ActorRef targetActor) {
            Objects.requireNonNull(entityType);
            Objects.requireNonNull(targetActor);
            this.hashMap.put(entityType, targetActor);
            return this;
        }

        public EntityRegionMap build() {
            return new EntityRegionMap(this);
        }
    }
}

