/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.ditto.internal.utils.cache.Cache;
import org.eclipse.ditto.internal.utils.cache.CacheKey;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;

public final class IdentityCache
implements Cache<CacheKey, Entry<CacheKey>> {
    public static final IdentityCache INSTANCE = new IdentityCache();

    private IdentityCache() {
    }

    public CompletableFuture<Optional<Entry<CacheKey>>> get(CacheKey key) {
        return CompletableFuture.completedFuture(this.getBlocking(key));
    }

    public CompletableFuture<Optional<Entry<CacheKey>>> getIfPresent(CacheKey key) {
        return this.get(key);
    }

    public Optional<Entry<CacheKey>> getBlocking(CacheKey key) {
        return Optional.of(Entry.permanent((Object)key));
    }

    public boolean invalidate(CacheKey key) {
        return false;
    }

    public void put(CacheKey key, Entry<CacheKey> value) {
    }

    public ConcurrentMap<CacheKey, Entry<CacheKey>> asMap() {
        throw new UnsupportedOperationException("IdentityCache may not be viewed as map");
    }
}

