/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.internal.utils.cache.CacheLookupContext;
import org.eclipse.ditto.policies.api.commands.sudo.SudoRetrievePolicy;
import org.eclipse.ditto.policies.model.PolicyId;

final class PolicyCommandFactory {
    private PolicyCommandFactory() {
        throw new AssertionError();
    }

    static SudoRetrievePolicy sudoRetrievePolicy(EntityId policyId, @Nullable CacheLookupContext cacheLookupContext) {
        return PolicyCommandFactory.sudoRetrievePolicy(PolicyId.of((CharSequence)policyId), cacheLookupContext);
    }

    static SudoRetrievePolicy sudoRetrievePolicy(PolicyId policyId, @Nullable CacheLookupContext cacheLookupContext) {
        return SudoRetrievePolicy.of((PolicyId)policyId, (DittoHeaders)Optional.ofNullable(cacheLookupContext).flatMap(CacheLookupContext::getDittoHeaders).map(headers -> DittoHeaders.newBuilder().authorizationContext(headers.getAuthorizationContext()).schemaVersion(headers.getImplementedSchemaVersion()).correlationId((CharSequence)("sudoRetrievePolicy-" + headers.getCorrelationId().orElseGet(() -> UUID.randomUUID().toString()))).build()).orElseGet(() -> DittoHeaders.newBuilder().correlationId((CharSequence)("sudoRetrievePolicy-" + UUID.randomUUID().toString())).build()));
    }
}

