/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.enforcers.Enforcer;

@Immutable
public final class PolicyEnforcer {
    @Nullable
    private final Policy policy;
    private final Enforcer enforcer;

    private PolicyEnforcer(@Nullable Policy policy, Enforcer enforcer) {
        this.policy = policy;
        this.enforcer = enforcer;
    }

    public static PolicyEnforcer of(@Nullable Policy policy, Enforcer enforcer) {
        return new PolicyEnforcer(policy, enforcer);
    }

    public static PolicyEnforcer of(Enforcer enforcer) {
        return new PolicyEnforcer(null, enforcer);
    }

    public static Entry<Enforcer> project(Entry<PolicyEnforcer> policyEnforcerEntry) {
        if (policyEnforcerEntry.exists()) {
            return Entry.of((long)policyEnforcerEntry.getRevision(), (Object)((PolicyEnforcer)policyEnforcerEntry.getValueOrThrow()).getEnforcer());
        }
        return Entry.nonexistent();
    }

    public static Entry<PolicyEnforcer> embed(Entry<Enforcer> enforcerEntry) {
        if (enforcerEntry.exists()) {
            return Entry.of((long)enforcerEntry.getRevision(), (Object)new PolicyEnforcer(null, (Enforcer)enforcerEntry.getValueOrThrow()));
        }
        return Entry.nonexistent();
    }

    public Optional<Policy> getPolicy() {
        return Optional.ofNullable(this.policy);
    }

    public Enforcer getEnforcer() {
        return this.enforcer;
    }
}

