/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import akka.actor.ActorRef;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.entity.Revision;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.internal.utils.cache.CacheKey;
import org.eclipse.ditto.internal.utils.cache.CacheLookupContext;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;
import org.eclipse.ditto.internal.utils.cacheloaders.ActorAskCacheLoader;
import org.eclipse.ditto.internal.utils.cacheloaders.PolicyCommandFactory;
import org.eclipse.ditto.internal.utils.cacheloaders.PolicyEnforcer;
import org.eclipse.ditto.policies.api.commands.sudo.SudoRetrievePolicyResponse;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.PolicyConstants;
import org.eclipse.ditto.policies.model.enforcers.PolicyEnforcers;
import org.eclipse.ditto.policies.model.signals.commands.exceptions.PolicyNotAccessibleException;

@Immutable
public final class PolicyEnforcerCacheLoader
implements AsyncCacheLoader<CacheKey, Entry<PolicyEnforcer>> {
    private final ActorAskCacheLoader<PolicyEnforcer, Command<?>> delegate;

    public PolicyEnforcerCacheLoader(Duration askTimeout, ActorRef policiesShardRegionProxy) {
        Objects.requireNonNull(askTimeout);
        Objects.requireNonNull(policiesShardRegionProxy);
        BiFunction<EntityId, CacheLookupContext, Command<?>> commandCreator = PolicyCommandFactory::sudoRetrievePolicy;
        BiFunction responseTransformer = PolicyEnforcerCacheLoader::handleSudoRetrievePolicyResponse;
        this.delegate = ActorAskCacheLoader.forShard(askTimeout, PolicyConstants.ENTITY_TYPE, policiesShardRegionProxy, commandCreator, responseTransformer);
    }

    public CompletableFuture<Entry<PolicyEnforcer>> asyncLoad(CacheKey key, Executor executor) {
        return this.delegate.asyncLoad(key, executor);
    }

    private static Entry<PolicyEnforcer> handleSudoRetrievePolicyResponse(Object response, @Nullable CacheLookupContext cacheLookupContext) {
        if (response instanceof SudoRetrievePolicyResponse) {
            SudoRetrievePolicyResponse sudoRetrievePolicyResponse = (SudoRetrievePolicyResponse)response;
            Policy policy = sudoRetrievePolicyResponse.getPolicy();
            long revision = policy.getRevision().map(Revision::toLong).orElseThrow(() -> new IllegalStateException("Bad SudoRetrievePolicyResponse: no revision"));
            return Entry.of((long)revision, (Object)PolicyEnforcer.of(policy, PolicyEnforcers.defaultEvaluator((Policy)policy)));
        }
        if (response instanceof PolicyNotAccessibleException) {
            return Entry.nonexistent();
        }
        throw new IllegalStateException("expect SudoRetrievePolicyResponse, got: " + response);
    }
}

