/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.internal.utils.cache.CacheLookupContext;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.things.api.commands.sudo.SudoRetrieveThing;
import org.eclipse.ditto.things.model.ThingId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThingCommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThingCommandFactory.class);

    private ThingCommandFactory() {
        throw new AssertionError();
    }

    static SudoRetrieveThing sudoRetrieveThing(EntityId thingId, @Nullable CacheLookupContext cacheLookupContext) {
        return ThingCommandFactory.sudoRetrieveThing(ThingId.of((CharSequence)thingId), cacheLookupContext);
    }

    static SudoRetrieveThing sudoRetrieveThing(ThingId thingId, @Nullable CacheLookupContext cacheLookupContext) {
        LOGGER.debug("Sending SudoRetrieveThing for Thing with ID <{}>", (Object)thingId);
        return SudoRetrieveThing.withOriginalSchemaVersion((ThingId)thingId, (JsonFieldSelector)Optional.ofNullable(cacheLookupContext).flatMap(CacheLookupContext::getJsonFieldSelector).orElse(null), (DittoHeaders)Optional.ofNullable(cacheLookupContext).flatMap(CacheLookupContext::getDittoHeaders).map(headers -> DittoHeaders.newBuilder().authorizationContext(headers.getAuthorizationContext()).schemaVersion(headers.getImplementedSchemaVersion()).correlationId((CharSequence)("sudoRetrieveThing-" + headers.getCorrelationId().orElseGet(() -> UUID.randomUUID().toString()))).build()).orElseGet(() -> DittoHeaders.newBuilder().correlationId((CharSequence)("sudoRetrieveThing-" + UUID.randomUUID().toString())).build()));
    }
}

