/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import akka.actor.ActorRef;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.entity.Revision;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.internal.utils.cache.CacheKey;
import org.eclipse.ditto.internal.utils.cache.CacheLookupContext;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;
import org.eclipse.ditto.internal.utils.cacheloaders.ActorAskCacheLoader;
import org.eclipse.ditto.internal.utils.cacheloaders.ThingCommandFactory;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.things.api.commands.sudo.SudoRetrieveThingResponse;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingConstants;
import org.eclipse.ditto.things.model.signals.commands.exceptions.ThingNotAccessibleException;

@Immutable
public final class ThingEnforcementIdCacheLoader
implements AsyncCacheLoader<CacheKey, Entry<CacheKey>> {
    private final ActorAskCacheLoader<CacheKey, Command<?>> delegate;

    public ThingEnforcementIdCacheLoader(Duration askTimeout, ActorRef shardRegionProxy) {
        BiFunction<EntityId, CacheLookupContext, Command<?>> commandCreator = ThingCommandFactory::sudoRetrieveThing;
        BiFunction responseTransformer = ThingEnforcementIdCacheLoader::handleSudoRetrieveThingResponse;
        this.delegate = ActorAskCacheLoader.forShard(askTimeout, ThingConstants.ENTITY_TYPE, shardRegionProxy, commandCreator, responseTransformer);
    }

    public CompletableFuture<Entry<CacheKey>> asyncLoad(CacheKey key, Executor executor) {
        return this.delegate.asyncLoad(key, executor);
    }

    private static Entry<CacheKey> handleSudoRetrieveThingResponse(Object response, @Nullable CacheLookupContext cacheLookupContext) {
        if (response instanceof SudoRetrieveThingResponse) {
            SudoRetrieveThingResponse sudoRetrieveThingResponse = (SudoRetrieveThingResponse)response;
            Thing thing = sudoRetrieveThingResponse.getThing();
            long revision = thing.getRevision().map(Revision::toLong).orElseThrow(ThingEnforcementIdCacheLoader.badThingResponse("no revision"));
            PolicyId policyId = (PolicyId)thing.getPolicyEntityId().orElseThrow(ThingEnforcementIdCacheLoader.badThingResponse("no PolicyId"));
            CacheKey resourceKey = CacheKey.of((EntityId)policyId);
            return Entry.of((long)revision, (Object)resourceKey);
        }
        if (response instanceof ThingNotAccessibleException) {
            return Entry.nonexistent();
        }
        throw new IllegalStateException("expect SudoRetrieveThingResponse, got: " + response);
    }

    private static Supplier<RuntimeException> badThingResponse(String message) {
        return () -> new IllegalStateException("Bad SudoRetrieveThingResponse: " + message);
    }
}

