/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.Patterns;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.WithEntityId;
import org.eclipse.ditto.base.model.exceptions.AskException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.WithDittoHeaders;
import org.eclipse.ditto.internal.utils.cacheloaders.config.AskWithRetryConfig;
import org.eclipse.ditto.internal.utils.pekko.logging.DittoLoggerFactory;
import org.eclipse.ditto.internal.utils.pekko.logging.ThreadSafeDittoLogger;
import scala.compat.java8.FutureConverters;
import scala.concurrent.ExecutionContext;

public final class AskWithRetry {
    private static final DittoRuntimeException DUMMY_DRE = new DittoRuntimeException("dummy", HttpStatus.INTERNAL_SERVER_ERROR, DittoHeaders.empty(), null, null, null, null){

        public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
            return this;
        }
    };
    private static final ThreadSafeDittoLogger LOGGER = DittoLoggerFactory.getThreadSafeLogger(AskWithRetry.class);
    public static final String ASK_WITH_RETRY_DISPATCHER = "ask-with-retry-dispatcher";

    private AskWithRetry() {
        throw new AssertionError();
    }

    public static <M, A> CompletionStage<A> askWithRetry(ActorRef actorToAsk, M message, AskWithRetryConfig config, ActorSystem actorSystem, Function<Object, A> responseMapper) {
        return AskWithRetry.askWithRetry(actorToAsk, message, config, actorSystem.getScheduler(), (Executor)actorSystem.dispatchers().lookup(ASK_WITH_RETRY_DISPATCHER), responseMapper);
    }

    public static <M, A> CompletionStage<A> askWithRetry(ActorRef actorToAsk, M message, AskWithRetryConfig config, Scheduler scheduler, Executor executor, Function<Object, A> responseMapper) {
        CompletionStage stage;
        DittoHeaders dittoHeaders;
        ConditionChecker.checkNotNull((Object)actorToAsk, (String)"actorToAsk");
        ConditionChecker.checkNotNull(message, (String)"message");
        ConditionChecker.checkNotNull((Object)config, (String)"config");
        ConditionChecker.checkNotNull((Object)scheduler, (String)"scheduler");
        ConditionChecker.checkNotNull((Object)executor, (String)"executor");
        ConditionChecker.checkNotNull(responseMapper, (String)"responseMapper");
        if (message instanceof WithDittoHeaders) {
            WithDittoHeaders withDittoHeaders = (WithDittoHeaders)message;
            dittoHeaders = withDittoHeaders.getDittoHeaders();
        } else {
            dittoHeaders = null;
        }
        int retryAttempts = config.getRetryAttempts();
        Callable<CompletionStage> askHandleCallable = () -> AskWithRetry.createAskHandle(actorToAsk, message, dittoHeaders, responseMapper, config.getAskTimeout());
        if (retryAttempts == 0) {
            stage = AskWithRetry.createAskHandle(actorToAsk, message, dittoHeaders, responseMapper, config.getAskTimeout());
        } else {
            switch (config.getRetryStrategy()) {
                case BACKOFF_DELAY: {
                    stage = Patterns.retry(askHandleCallable, (int)retryAttempts, (Duration)config.getBackoffDelayMin(), (Duration)config.getBackoffDelayMax(), (double)config.getBackoffDelayRandomFactor(), (Scheduler)scheduler, (ExecutionContext)FutureConverters.fromExecutor((Executor)executor));
                    break;
                }
                case FIXED_DELAY: {
                    stage = Patterns.retry(askHandleCallable, (int)retryAttempts, (Duration)config.getFixedDelay(), (Scheduler)scheduler, (ExecutionContext)FutureConverters.fromExecutor((Executor)executor));
                    break;
                }
                case NO_DELAY: {
                    stage = Patterns.retry(askHandleCallable, (int)retryAttempts, (ExecutionContext)FutureConverters.fromExecutor((Executor)executor));
                    break;
                }
                default: {
                    stage = AskWithRetry.createAskHandle(actorToAsk, message, dittoHeaders, responseMapper, config.getAskTimeout());
                }
            }
        }
        return stage.handle(AskWithRetry.handleRetryResult(dittoHeaders));
    }

    private static <M, A> CompletionStage<AskResult<A>> createAskHandle(ActorRef actorToAsk, M message, @Nullable DittoHeaders dittoHeaders, Function<Object, A> responseMapper, Duration askTimeout) {
        return Patterns.ask((ActorRef)actorToAsk, message, (Duration)askTimeout).handle((response, throwable) -> {
            if (null != throwable) {
                DittoRuntimeException dre = DittoRuntimeException.asDittoRuntimeException((Throwable)throwable, cause -> DUMMY_DRE);
                if (dre != DUMMY_DRE) {
                    return new AskFailure(dre);
                }
                if (throwable instanceof AskTimeoutException) {
                    EntityId entityId;
                    ThreadSafeDittoLogger l = LOGGER;
                    if (null != dittoHeaders) {
                        l = LOGGER.withCorrelationId(dittoHeaders);
                    } else if (message instanceof WithDittoHeaders) {
                        WithDittoHeaders withDittoHeaders = (WithDittoHeaders)message;
                        l = LOGGER.withCorrelationId(withDittoHeaders.getDittoHeaders());
                    }
                    if (message instanceof WithEntityId) {
                        WithEntityId withEntityId = (WithEntityId)message;
                        entityId = withEntityId.getEntityId();
                    } else {
                        entityId = null;
                    }
                    l.warn("Got AskTimeout during ask for message <{}> and entityId <{} / {}> - retrying.. : <{}>", new Object[]{message.getClass().getSimpleName(), entityId, entityId != null ? entityId.getEntityType() : null, throwable.getMessage()});
                }
                throw new UnknownAskRuntimeException((Throwable)throwable);
            }
            try {
                return new AskSuccess(responseMapper.apply(response));
            }
            catch (DittoRuntimeException dre) {
                return new AskFailure(dre);
            }
        });
    }

    private static <A> BiFunction<AskResult<A>, Throwable, A> handleRetryResult(@Nullable DittoHeaders dittoHeaders) {
        return (askResult, throwable) -> {
            if (null != throwable) {
                Throwable cause = throwable instanceof UnknownAskRuntimeException ? throwable.getCause() : throwable;
                throw DittoRuntimeException.asDittoRuntimeException((Throwable)cause, t -> {
                    DittoRuntimeExceptionBuilder exceptionBuilder = AskException.newBuilder().cause(t);
                    if (null != dittoHeaders) {
                        exceptionBuilder.dittoHeaders(dittoHeaders);
                    }
                    return exceptionBuilder.build();
                });
            }
            if (askResult.getDittoRuntimeException().isPresent()) {
                throw askResult.getDittoRuntimeException().get();
            }
            return askResult.getAnswer().orElse(null);
        };
    }

    private static final class UnknownAskRuntimeException
    extends RuntimeException {
        UnknownAskRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static interface AskResult<A> {
        public Optional<A> getAnswer();

        public Optional<DittoRuntimeException> getDittoRuntimeException();
    }

    private static final class AskFailure<A>
    implements AskResult<A> {
        private final DittoRuntimeException dittoRuntimeException;

        AskFailure(DittoRuntimeException dittoRuntimeException) {
            this.dittoRuntimeException = dittoRuntimeException;
        }

        @Override
        public Optional<A> getAnswer() {
            return Optional.empty();
        }

        @Override
        public Optional<DittoRuntimeException> getDittoRuntimeException() {
            return Optional.of(this.dittoRuntimeException);
        }
    }

    private static final class AskSuccess<A>
    implements AskResult<A> {
        private final A answer;

        AskSuccess(A answer) {
            this.answer = answer;
        }

        @Override
        public Optional<A> getAnswer() {
            return Optional.of(this.answer);
        }

        @Override
        public Optional<DittoRuntimeException> getDittoRuntimeException() {
            return Optional.empty();
        }
    }
}

