/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Scheduler;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.internal.utils.cache.entry.Entry;
import org.eclipse.ditto.internal.utils.cacheloaders.AskWithRetry;
import org.eclipse.ditto.internal.utils.cacheloaders.EntityRegionMap;
import org.eclipse.ditto.internal.utils.cacheloaders.config.AskWithRetryConfig;
import org.eclipse.ditto.internal.utils.pekko.logging.DittoLoggerFactory;
import org.eclipse.ditto.internal.utils.pekko.logging.ThreadSafeDittoLogger;

@Immutable
public final class ActorAskCacheLoader<V, T, K extends EntityId>
implements AsyncCacheLoader<K, Entry<V>> {
    private static final ThreadSafeDittoLogger LOGGER = DittoLoggerFactory.getThreadSafeLogger(ActorAskCacheLoader.class);
    private final AskWithRetryConfig askWithRetryConfig;
    private final Scheduler scheduler;
    private final Function<EntityType, ActorRef> entityRegionProvider;
    private final Map<EntityType, Function<K, T>> commandCreatorMap;
    private final Map<EntityType, Function<Object, Entry<V>>> responseTransformerMap;

    private ActorAskCacheLoader(AskWithRetryConfig askWithRetryConfig, Scheduler scheduler, Function<EntityType, ActorRef> entityRegionProvider, Map<EntityType, Function<K, T>> commandCreatorMap, Map<EntityType, Function<Object, Entry<V>>> responseTransformerMap) {
        this.askWithRetryConfig = Objects.requireNonNull(askWithRetryConfig);
        this.scheduler = scheduler;
        this.entityRegionProvider = Objects.requireNonNull(entityRegionProvider);
        this.commandCreatorMap = Map.copyOf(Objects.requireNonNull(commandCreatorMap));
        this.responseTransformerMap = Map.copyOf(Objects.requireNonNull(responseTransformerMap));
    }

    public static <V, K extends EntityId> ActorAskCacheLoader<V, Command<?>, K> forShard(AskWithRetryConfig askWithRetryConfig, Scheduler scheduler, EntityType entityType, ActorRef entityRegion, Function<K, Command<?>> commandCreator, Function<Object, Entry<V>> responseTransformer) {
        Objects.requireNonNull(askWithRetryConfig);
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(entityRegion);
        Objects.requireNonNull(commandCreator);
        Objects.requireNonNull(responseTransformer);
        return new ActorAskCacheLoader(askWithRetryConfig, scheduler, EntityRegionMap.singleton(entityType, entityRegion), Collections.singletonMap(entityType, commandCreator), Collections.singletonMap(entityType, responseTransformer));
    }

    public CompletableFuture<Entry<V>> asyncLoad(K entityId, Executor executor) {
        EntityType entityType = entityId.getEntityType();
        return CompletableFuture.supplyAsync(() -> this.getCommand(entityType, entityId), executor).thenCompose(command -> {
            ActorRef entityRegion = this.getEntityRegion(entityType);
            LOGGER.debug("Going to retrieve cache entry for key <{}> with command <{}>: ", (Object)entityId, command);
            return AskWithRetry.askWithRetry(entityRegion, command, this.askWithRetryConfig, this.scheduler, executor, response -> this.transformResponse(entityType, response));
        });
    }

    private ActorRef getEntityRegion(EntityType entityType) {
        ActorRef entityRegion = this.entityRegionProvider.apply(entityType);
        if (entityRegion == null) {
            throw new IllegalStateException("null entity region returned for resource type " + entityType);
        }
        return entityRegion;
    }

    private T getCommand(EntityType entityType, K id) {
        Function<K, K> commandCreator = this.commandCreatorMap.get(entityType);
        if (commandCreator == null) {
            String message = String.format("Don't know how to create retrieve command for resource type <%s> and id <%s>", entityType, id);
            throw new NullPointerException(message);
        }
        return commandCreator.apply(id);
    }

    private Entry<V> transformResponse(EntityType entityType, Object response) {
        return (Entry)((Function)ConditionChecker.checkNotNull(this.responseTransformerMap.get(entityType), (String)"entityType")).apply(response);
    }
}

