/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders.config;

import java.time.Duration;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.cacheloaders.config.RetryStrategy;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;

@Immutable
public interface AskWithRetryConfig {
    public Duration getAskTimeout();

    public RetryStrategy getRetryStrategy();

    public int getRetryAttempts();

    public Duration getFixedDelay();

    public Duration getBackoffDelayMin();

    public Duration getBackoffDelayMax();

    public double getBackoffDelayRandomFactor();

    public static enum AskWithRetryConfigValue implements KnownConfigValue
    {
        ASK_TIMEOUT("ask-timeout", Duration.ofSeconds(3L)),
        RETRY_STRATEGY("retry-strategy", RetryStrategy.OFF.name()),
        RETRY_ATTEMPTS("retry-attempts", 3),
        FIXED_DELAY("fixed-delay", Duration.ofSeconds(5L)),
        BACKOFF_DELAY_MIN("backoff-delay.min", Duration.ofSeconds(1L)),
        BACKOFF_DELAY_MAX("backoff-delay.max", Duration.ofSeconds(10L)),
        BACKOFF_DELAY_RANDOM_FACTOR("backoff-delay.random-factor", 0.5);

        private final String path;
        private final Object defaultValue;

        private AskWithRetryConfigValue(String thePath, Object theDefaultValue) {
            this.path = thePath;
            this.defaultValue = theDefaultValue;
        }

        public String getConfigPath() {
            return this.path;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

