/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.cacheloaders.config;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.cacheloaders.config.AskWithRetryConfig;
import org.eclipse.ditto.internal.utils.cacheloaders.config.RetryStrategy;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.WithConfigPath;

@Immutable
public final class DefaultAskWithRetryConfig
implements AskWithRetryConfig {
    private final Duration askTimeout;
    private final RetryStrategy retryStrategy;
    private final int retryAttempts;
    private final Duration fixedDelay;
    private final Duration backoffDelayMin;
    private final Duration backoffDelayMax;
    private final double backoffDelayRandomFactor;

    private DefaultAskWithRetryConfig(ConfigWithFallback configWithFallback) {
        this.askTimeout = configWithFallback.getNonNegativeAndNonZeroDurationOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.ASK_TIMEOUT);
        this.retryStrategy = (RetryStrategy)configWithFallback.getEnum(RetryStrategy.class, AskWithRetryConfig.AskWithRetryConfigValue.RETRY_STRATEGY.getConfigPath());
        this.retryAttempts = configWithFallback.getNonNegativeIntOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.RETRY_ATTEMPTS);
        this.fixedDelay = configWithFallback.getNonNegativeDurationOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.FIXED_DELAY);
        this.backoffDelayMin = configWithFallback.getNonNegativeDurationOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.BACKOFF_DELAY_MIN);
        this.backoffDelayMax = configWithFallback.getNonNegativeDurationOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.BACKOFF_DELAY_MAX);
        this.backoffDelayRandomFactor = configWithFallback.getNonNegativeDoubleOrThrow((WithConfigPath)AskWithRetryConfig.AskWithRetryConfigValue.BACKOFF_DELAY_RANDOM_FACTOR);
    }

    public static DefaultAskWithRetryConfig of(Config config, String configPath) {
        return new DefaultAskWithRetryConfig(ConfigWithFallback.newInstance((Config)config, (String)configPath, (KnownConfigValue[])AskWithRetryConfig.AskWithRetryConfigValue.values()));
    }

    @Override
    public Duration getAskTimeout() {
        return this.askTimeout;
    }

    @Override
    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @Override
    public Duration getFixedDelay() {
        return this.fixedDelay;
    }

    @Override
    public Duration getBackoffDelayMin() {
        return this.backoffDelayMin;
    }

    @Override
    public Duration getBackoffDelayMax() {
        return this.backoffDelayMax;
    }

    @Override
    public double getBackoffDelayRandomFactor() {
        return this.backoffDelayRandomFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAskWithRetryConfig that = (DefaultAskWithRetryConfig)o;
        return this.retryAttempts == that.retryAttempts && Double.compare(that.backoffDelayRandomFactor, this.backoffDelayRandomFactor) == 0 && this.askTimeout.equals(that.askTimeout) && this.retryStrategy == that.retryStrategy && this.fixedDelay.equals(that.fixedDelay) && this.backoffDelayMin.equals(that.backoffDelayMin) && this.backoffDelayMax.equals(that.backoffDelayMax);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.askTimeout, this.retryStrategy, this.retryAttempts, this.fixedDelay, this.backoffDelayMin, this.backoffDelayMax, this.backoffDelayRandomFactor});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [askTimeout=" + this.askTimeout + ", retryStrategy=" + this.retryStrategy + ", retryAttempts=" + this.retryAttempts + ", fixedDelay=" + this.fixedDelay + ", backoffDelayMin=" + this.backoffDelayMin + ", backoffDelayMax=" + this.backoffDelayMax + ", backoffDelayRandomFactor=" + this.backoffDelayRandomFactor + "]";
    }
}

