/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNumber;
import org.bson.BsonValue;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;

abstract class AbstractBasicDBMapper<T, J extends JsonValue>
implements Function<T, J> {
    final Function<String, String> jsonKeyNameReviser;

    AbstractBasicDBMapper(Function<String, String> theJsonKeyNameReviser) {
        this.jsonKeyNameReviser = (Function)ConditionChecker.checkNotNull(theJsonKeyNameReviser, (String)"The JSON key name reviser");
    }

    static JsonObject mapBsonDocumentToJsonObject(BsonDocument bsonDocument, Function<String, String> jsonKeyNameReviser) {
        return (JsonObject)bsonDocument.entrySet().stream().map(e -> JsonFactory.newField((JsonKey)AbstractBasicDBMapper.reviseKeyName((String)e.getKey(), jsonKeyNameReviser), (JsonValue)AbstractBasicDBMapper.mapBsonValueToJsonValue((BsonValue)e.getValue(), jsonKeyNameReviser))).collect(JsonCollectors.fieldsToObject());
    }

    static JsonArray mapBsonArrayToJsonArray(BsonArray bsonArray, Function<String, String> jsonKeyNameReviser) {
        return (JsonArray)bsonArray.stream().map(obj -> AbstractBasicDBMapper.mapBsonValueToJsonValue(obj, jsonKeyNameReviser)).collect(JsonCollectors.valuesToArray());
    }

    private static JsonKey reviseKeyName(String jsonKeyName, Function<String, String> jsonKeyNameReviser) {
        return JsonFactory.newKey((CharSequence)jsonKeyNameReviser.apply(jsonKeyName));
    }

    private static JsonValue mapBsonValueToJsonValue(@Nullable BsonValue bsonValue, Function<String, String> jsonKeyNameReviser) {
        JsonValue result;
        if (bsonValue == null || bsonValue.isNull()) {
            result = JsonFactory.nullLiteral();
        } else if (bsonValue.isString()) {
            result = JsonFactory.newValue((String)bsonValue.asString().getValue());
        } else if (bsonValue.isNumber()) {
            result = AbstractBasicDBMapper.mapBsonNumberToJsonNumber(bsonValue.asNumber());
        } else if (bsonValue.isDocument()) {
            result = AbstractBasicDBMapper.mapBsonDocumentToJsonObject(bsonValue.asDocument(), jsonKeyNameReviser);
        } else if (bsonValue.isArray()) {
            result = AbstractBasicDBMapper.mapBsonArrayToJsonArray(bsonValue.asArray(), jsonKeyNameReviser);
        } else if (bsonValue.isBoolean()) {
            result = JsonFactory.newValue((boolean)bsonValue.asBoolean().getValue());
        } else if (bsonValue.isTimestamp()) {
            Instant instant = Instant.ofEpochSecond(bsonValue.asTimestamp().getTime());
            result = JsonFactory.newValue((String)instant.toString());
        } else {
            result = JsonFactory.nullLiteral();
        }
        return result;
    }

    private static JsonValue mapBsonNumberToJsonNumber(BsonNumber asNumber) {
        JsonValue result = asNumber.isDouble() ? JsonFactory.newValue((double)asNumber.asDouble().doubleValue()) : (asNumber.isInt64() ? JsonFactory.newValue((long)asNumber.asInt64().longValue()) : JsonFactory.newValue((int)asNumber.asInt32().intValue()));
        return result;
    }
}

