/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.actor.ExtendedActorSystem;
import akka.persistence.journal.EventAdapter;
import akka.persistence.journal.EventSeq;
import akka.persistence.journal.Tagged;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.EventRegistry;
import org.eclipse.ditto.base.model.signals.events.EventsourcedEvent;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoBsonJson;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoEventAdapter<T extends Event<?>>
implements EventAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMongoEventAdapter.class);
    private static final Predicate<JsonField> IS_REVISION = field -> field.getDefinition().filter(EventsourcedEvent.JsonFields.REVISION::equals).isPresent();
    @Nullable
    protected final ExtendedActorSystem system;
    protected final EventRegistry<T> eventRegistry;

    protected AbstractMongoEventAdapter(@Nullable ExtendedActorSystem system, EventRegistry<T> eventRegistry) {
        this.system = system;
        this.eventRegistry = eventRegistry;
    }

    public String manifest(Object event) {
        if (event instanceof Event) {
            return ((Event)event).getType();
        }
        throw new IllegalArgumentException("Unable to create manifest for a non-'Event' object! Was: " + event.getClass());
    }

    public Object toJournal(Object event) {
        if (event instanceof Event) {
            Event theEvent = (Event)event;
            JsonSchemaVersion schemaVersion = theEvent.getImplementedSchemaVersion();
            JsonObject jsonObject = this.performToJournalMigration((JsonObject)theEvent.toJson(schemaVersion, IS_REVISION.negate()));
            BsonDocument bson = DittoBsonJson.getInstance().parse(jsonObject);
            Set tags = theEvent.getDittoHeaders().getJournalTags();
            return new Tagged((Object)bson, tags);
        }
        throw new IllegalArgumentException("Unable to toJournal a non-'Event' object! Was: " + event.getClass());
    }

    public EventSeq fromJournal(Object event, String manifest) {
        if (event instanceof BsonValue) {
            JsonValue jsonValue = DittoBsonJson.getInstance().serialize((BsonValue)event);
            try {
                JsonObject jsonObject = jsonValue.asObject().setValue((CharSequence)EventsourcedEvent.JsonFields.REVISION.getPointer(), 0L);
                Event result = (Event)this.eventRegistry.parse(this.performFromJournalMigration(jsonObject), DittoHeaders.empty());
                return EventSeq.single((Object)result);
            }
            catch (DittoRuntimeException | JsonParseException e) {
                if (this.system != null) {
                    this.system.log().error(e, "Could not deserialize Event JSON: '{}'", (Object)jsonValue);
                } else {
                    LOGGER.error("Could not deserialize Event JSON: '{}': {}", (Object)jsonValue, (Object)e.getMessage());
                }
                return EventSeq.empty();
            }
        }
        throw new IllegalArgumentException("Unable to fromJournal a non-'BsonValue' object! Was: " + event.getClass());
    }

    protected JsonObject performToJournalMigration(JsonObject jsonObject) {
        return jsonObject;
    }

    protected JsonObject performFromJournalMigration(JsonObject jsonObject) {
        return jsonObject;
    }
}

