/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotOffer;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.BsonValue;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.internal.utils.persistence.SnapshotAdapter;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoBsonJson;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractMongoSnapshotAdapter<T extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField>>
implements SnapshotAdapter<T> {
    private final Logger logger;

    protected AbstractMongoSnapshotAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Object toSnapshotStore(T snapshotEntity) {
        JsonObject json = this.convertToJson((Jsonifiable.WithFieldSelectorAndPredicate)ConditionChecker.checkNotNull(snapshotEntity, (String)"snapshot entity"));
        this.onSnapshotStoreConversion(snapshotEntity, json);
        DittoBsonJson dittoBsonJson = DittoBsonJson.getInstance();
        return dittoBsonJson.parse(json);
    }

    protected void onSnapshotStoreConversion(T snapshotEntity, JsonObject json) {
    }

    @Override
    public T fromSnapshotStore(SnapshotOffer snapshotOffer) {
        return this.convertSnapshotToJsonifiable(snapshotOffer.snapshot());
    }

    @Override
    public T fromSnapshotStore(SelectedSnapshot selectedSnapshot) {
        return this.convertSnapshotToJsonifiable(selectedSnapshot.snapshot());
    }

    protected JsonObject convertToJson(T snapshotEntity) {
        ConditionChecker.checkNotNull(snapshotEntity, (String)"snapshot entity");
        return (JsonObject)snapshotEntity.toJson(snapshotEntity.getImplementedSchemaVersion(), FieldType.all());
    }

    @Nullable
    private T convertSnapshotToJsonifiable(Object rawSnapshotEntity) {
        return this.tryToCreateJsonifiableFrom(AbstractMongoSnapshotAdapter.convertSnapshotEntityToJson(rawSnapshotEntity));
    }

    private static JsonObject convertSnapshotEntityToJson(Object rawSnapshotEntity) {
        ConditionChecker.checkNotNull((Object)rawSnapshotEntity, (String)"raw snapshot entity");
        if (rawSnapshotEntity instanceof BsonValue) {
            return AbstractMongoSnapshotAdapter.convertToJson((BsonValue)rawSnapshotEntity);
        }
        String pattern = "Unable to create a Jsonifiable from <{0}>! Expected was a BsonDocument instance.";
        throw new IllegalArgumentException(MessageFormat.format("Unable to create a Jsonifiable from <{0}>! Expected was a BsonDocument instance.", rawSnapshotEntity.getClass()));
    }

    private static JsonObject convertToJson(BsonValue bsonValue) {
        ConditionChecker.checkNotNull((Object)bsonValue, (String)"BsonValue to be converted");
        DittoBsonJson dittoBsonJson = DittoBsonJson.getInstance();
        JsonObject jsonObject = dittoBsonJson.serialize(bsonValue).asObject();
        return (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> jsonObject);
    }

    @Nullable
    private T tryToCreateJsonifiableFrom(JsonObject jsonObject) {
        try {
            return this.createJsonifiableFrom(jsonObject);
        }
        catch (DittoRuntimeException | JsonParseException e) {
            String pattern = "Failed to deserialize JSON <{0}>!";
            this.logger.error(MessageFormat.format("Failed to deserialize JSON <{0}>!", jsonObject), e);
            return null;
        }
    }

    protected abstract T createJsonifiableFrom(JsonObject var1);
}

