/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonDocument;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.persistence.mongo.AbstractBasicDBMapper;
import org.eclipse.ditto.json.JsonObject;

@Immutable
final class BsonDocumentToJsonObjectMapper
extends AbstractBasicDBMapper<BsonDocument, JsonObject> {
    private BsonDocumentToJsonObjectMapper(Function<String, String> theJsonKeyNameReviser) {
        super(theJsonKeyNameReviser);
    }

    public static BsonDocumentToJsonObjectMapper getInstance(Function<String, String> jsonKeyNameReviser) {
        return new BsonDocumentToJsonObjectMapper(jsonKeyNameReviser);
    }

    @Override
    public JsonObject apply(BsonDocument bsonDocument) {
        return BsonDocumentToJsonObjectMapper.mapBsonDocumentToJsonObject((BsonDocument)ConditionChecker.checkNotNull((Object)bsonDocument, (String)"BsonDocument to be mapped"), this.jsonKeyNameReviser);
    }
}

