/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import com.mongodb.MongoClientSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.eclipse.ditto.base.model.common.ConditionChecker;

@Immutable
public final class BsonUtil {
    private static final String NULL_STRING = Objects.toString(null);
    private static final CodecRegistry CODEC_REGISTRY = MongoClientSettings.builder().build().getCodecRegistry();

    private BsonUtil() {
        throw new AssertionError();
    }

    public static BsonDocument toBsonDocument(Bson bsonObj) {
        ConditionChecker.checkNotNull((Object)bsonObj, (String)"BSON object to be converted");
        return bsonObj.toBsonDocument(BsonDocument.class, CODEC_REGISTRY);
    }

    @Nullable
    public static BsonDocument toBsonDocumentOrNull(@Nullable Bson bsonObj) {
        if (bsonObj == null) {
            return null;
        }
        return BsonUtil.toBsonDocument(bsonObj);
    }

    public static List<BsonDocument> toBsonDocuments(Collection<Bson> bsonObjs) {
        ConditionChecker.checkNotNull(bsonObjs, (String)"BSON objects to be converted");
        return bsonObjs.stream().map(BsonUtil::toBsonDocument).collect(Collectors.toList());
    }

    public static <T> T getRequiredDocumentValueAt(Document document, String key, Class<T> clazz) {
        T value = BsonUtil.getDocumentValueOrNullAt(document, key, clazz);
        if (value == null) {
            throw new NullPointerException("Key not found: " + key);
        }
        return value;
    }

    public static <T> T getDocumentWithDefaultAt(Document document, String key, Class<T> clazz, T defaultValue) {
        T value = BsonUtil.getDocumentValueOrNullAt(document, key, clazz);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public static <T> T getValueByPath(Bson bsonObj, String path) {
        ConditionChecker.checkNotNull((Object)bsonObj, (String)"BSON object which provides the value");
        ConditionChecker.checkNotNull((Object)path, (String)"path");
        BsonDocument doc = BsonUtil.toBsonDocument(bsonObj);
        List<String> paths = Arrays.asList(path.split("\\."));
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("Empty path not allowed");
        }
        String topLevelKey = paths.get(0);
        String remainingPath = String.join((CharSequence)".", paths.subList(1, paths.size()));
        BsonValue subBson = doc.get((Object)topLevelKey);
        if (subBson == null) {
            return null;
        }
        if (remainingPath.isEmpty()) {
            BsonValue result = subBson;
            return (T)result;
        }
        return BsonUtil.getValueByPath((Bson)subBson, remainingPath);
    }

    public static String prettyPrint(@Nullable Collection<Bson> bsons) {
        if (bsons == null) {
            return NULL_STRING;
        }
        return "[" + bsons.stream().map(BsonUtil::prettyPrint).collect(Collectors.joining(",\n")) + "]";
    }

    public static String prettyPrint(@Nullable Bson bson) {
        if (bson == null) {
            return NULL_STRING;
        }
        return BsonUtil.toBsonDocument(bson).toJson();
    }

    @Nullable
    private static <T> T getDocumentValueOrNullAt(Document document, String key, Class<T> clazz) {
        return (T)document.get((Object)key, clazz);
    }
}

