/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.actor.Props;
import java.util.function.Function;
import org.eclipse.ditto.internal.models.streaming.EntityIdWithRevision;
import org.eclipse.ditto.internal.utils.persistence.mongo.AbstractPersistenceStreamingActor;
import org.eclipse.ditto.internal.utils.persistence.mongo.streaming.MongoReadJournal;
import org.eclipse.ditto.internal.utils.persistence.mongo.streaming.PidWithSeqNr;
import org.eclipse.ditto.utils.jsr305.annotations.AllValuesAreNonnullByDefault;

@AllValuesAreNonnullByDefault
public final class DefaultPersistenceStreamingActor<T extends EntityIdWithRevision<?>>
extends AbstractPersistenceStreamingActor<T> {
    private final Class<T> elementClass;

    private DefaultPersistenceStreamingActor(Class<T> elementClass, Function<PidWithSeqNr, T> entityMapper, Function<EntityIdWithRevision<?>, PidWithSeqNr> entityUnmapper) {
        super(entityMapper, entityUnmapper);
        this.elementClass = elementClass;
    }

    private DefaultPersistenceStreamingActor(Class<T> elementClass, Function<PidWithSeqNr, T> entityMapper, Function<EntityIdWithRevision<?>, PidWithSeqNr> entityUnmapper, MongoReadJournal readJournal) {
        super(entityMapper, entityUnmapper, readJournal);
        this.elementClass = elementClass;
    }

    public static <T extends EntityIdWithRevision<?>> Props props(Class<T> elementClass, Function<PidWithSeqNr, T> entityMapper, Function<EntityIdWithRevision<?>, PidWithSeqNr> entityUnmapper) {
        return Props.create(DefaultPersistenceStreamingActor.class, (Object[])new Object[]{elementClass, entityMapper, entityUnmapper});
    }

    static <T extends EntityIdWithRevision<?>> Props propsForTests(Class<T> elementClass, Function<PidWithSeqNr, T> entityMapper, Function<EntityIdWithRevision<?>, PidWithSeqNr> entityUnmapper, MongoReadJournal readJournal) {
        return Props.create(DefaultPersistenceStreamingActor.class, (Object[])new Object[]{elementClass, entityMapper, entityUnmapper, readJournal});
    }

    @Override
    protected Class<T> getElementClass() {
        return this.elementClass;
    }
}

