/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.util.function.Function;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.persistence.mongo.BsonArrayToJsonObjectMapper;
import org.eclipse.ditto.internal.utils.persistence.mongo.BsonDocumentToJsonObjectMapper;
import org.eclipse.ditto.internal.utils.persistence.mongo.JsonValueToDbEntityMapper;
import org.eclipse.ditto.internal.utils.persistence.mongo.KeyNameReviser;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;

public final class DittoBsonJson {
    private static final DittoBsonJson INSTANCE = DittoBsonJson.newInstance();
    private final Function<JsonObject, BsonDocument> jsonObjectToBsonDocumentMapper;
    private final Function<JsonArray, BsonArray> jsonArrayToBsonArrayMapper;
    private final Function<BsonDocument, JsonObject> bsonDocumentToJsonObjectMapper;
    private final Function<BsonArray, JsonArray> bsonArrayToJsonObjectMapper;

    private DittoBsonJson(Function<JsonObject, BsonDocument> jsonObjectToBsonDocumentMapper, Function<JsonArray, BsonArray> jsonArrayToBsonArrayMapper, Function<BsonDocument, JsonObject> bsonDocumentToJsonObjectMapper, Function<BsonArray, JsonArray> bsonArrayToJsonObjectMapper) {
        this.jsonObjectToBsonDocumentMapper = jsonObjectToBsonDocumentMapper;
        this.jsonArrayToBsonArrayMapper = jsonArrayToBsonArrayMapper;
        this.bsonDocumentToJsonObjectMapper = bsonDocumentToJsonObjectMapper;
        this.bsonArrayToJsonObjectMapper = bsonArrayToJsonObjectMapper;
    }

    public static DittoBsonJson getInstance() {
        return INSTANCE;
    }

    private static DittoBsonJson newInstance() {
        KeyNameReviser jsonToMongoDbKeyNameReviser = KeyNameReviser.escapeProblematicPlainChars();
        KeyNameReviser jsonKeyNameReviser = KeyNameReviser.decodeKnownUnicodeChars();
        return new DittoBsonJson(JsonValueToDbEntityMapper.forJsonObject(jsonToMongoDbKeyNameReviser), JsonValueToDbEntityMapper.forJsonArray(jsonToMongoDbKeyNameReviser), BsonDocumentToJsonObjectMapper.getInstance(jsonKeyNameReviser), BsonArrayToJsonObjectMapper.getInstance(jsonKeyNameReviser));
    }

    public JsonValue serialize(BsonValue bsonValue) {
        ConditionChecker.checkNotNull((Object)bsonValue, (String)"BsonValue to be serialized");
        if (bsonValue instanceof BsonDocument) {
            return this.serialize((BsonDocument)bsonValue);
        }
        if (bsonValue instanceof BsonArray) {
            return this.serialize((BsonArray)bsonValue);
        }
        throw new IllegalArgumentException("Can only serialize BsonDocument or BsonArray");
    }

    public JsonObject serialize(BsonDocument bsonDocument) {
        return this.bsonDocumentToJsonObjectMapper.apply((BsonDocument)ConditionChecker.checkNotNull((Object)bsonDocument, (String)"BsonDocument to be serialized"));
    }

    public JsonArray serialize(BsonArray bsonArray) {
        return this.bsonArrayToJsonObjectMapper.apply((BsonArray)ConditionChecker.checkNotNull((Object)bsonArray, (String)"BsonArray to be serialized"));
    }

    public BsonDocument parse(JsonObject jsonObject) {
        return this.jsonObjectToBsonDocumentMapper.apply(jsonObject);
    }

    public BsonArray parse(JsonArray jsonArray) {
        return this.jsonArrayToBsonArrayMapper.apply(jsonArray);
    }
}

