/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;

@Immutable
public final class DittoMongoClientSettings {
    private final Duration maxQueryTime;

    private DittoMongoClientSettings(Builder builder) {
        this.maxQueryTime = builder.maxQueryTime;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public Duration getMaxQueryTime() {
        return this.maxQueryTime;
    }

    @NotThreadSafe
    public static final class Builder {
        private static final Duration DEFAULT_MAX_QUERY_TIME = (Duration)MongoDbConfig.MongoDbConfigValue.MAX_QUERY_TIME.getDefaultValue();
        private Duration maxQueryTime = DEFAULT_MAX_QUERY_TIME;

        private Builder() {
        }

        public Builder maxQueryTime(long amount, TemporalUnit temporalUnit) {
            return this.maxQueryTime(Duration.of(amount, temporalUnit));
        }

        public Builder maxQueryTime(@Nullable Duration maxQueryTime) {
            this.maxQueryTime = null != maxQueryTime ? maxQueryTime : DEFAULT_MAX_QUERY_TIME;
            return this;
        }

        public DittoMongoClientSettings build() {
            return new DittoMongoClientSettings(this);
        }
    }
}

