/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.contrib.persistence.mongodb.MongoCollectionCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.ditto.internal.utils.cache.CaffeineCache;
import scala.Function1;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public final class DittoMongoCollectionCache<C>
implements MongoCollectionCache<Future<C>> {
    private final CaffeineCache<String, C> cache;

    public DittoMongoCollectionCache(Config config) {
        String ttl = "expire-after-write";
        String maxSize = "max-size";
        Caffeine caffeine = Caffeine.newBuilder();
        DittoMongoCollectionCache.tryLookup("expire-after-write", arg_0 -> ((Config)config).getDuration(arg_0)).ifPresent(arg_0 -> ((Caffeine)caffeine).expireAfterWrite(arg_0));
        DittoMongoCollectionCache.tryLookup("max-size", arg_0 -> ((Config)config).getLong(arg_0)).ifPresent(arg_0 -> ((Caffeine)caffeine).maximumSize(arg_0));
        this.cache = CaffeineCache.of((Caffeine)caffeine);
    }

    public Future<C> getOrElseCreate(String collectionName, Function1<String, Future<C>> collectionCreator) {
        return FutureConverters.toScala((CompletionStage)this.cache.get((Object)collectionName, (key, ec) -> FutureConverters.toJava((Future)((Future)collectionCreator.apply(key))).toCompletableFuture()));
    }

    public void invalidate(String collectionName) {
        this.cache.invalidate((Object)collectionName);
    }

    private static <T> Optional<T> tryLookup(String key, Function<String, T> lookup) {
        try {
            return Optional.of(lookup.apply(key));
        }
        catch (ConfigException e) {
            return Optional.empty();
        }
    }
}

