/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.utils.jsr305.annotations.AllParametersAndReturnValuesAreNonnullByDefault;

@AllParametersAndReturnValuesAreNonnullByDefault
@Immutable
final class JsonValueToDbEntityMapper {
    private final Function<String, String> jsonKeyNameReviser;

    private JsonValueToDbEntityMapper(Function<String, String> theJsonKeyNameReviser) {
        this.jsonKeyNameReviser = (Function)ConditionChecker.checkNotNull(theJsonKeyNameReviser, (String)"JSON key name reviser");
    }

    public static Function<JsonObject, BsonDocument> forJsonObject(Function<String, String> jsonKeyNameReviser) {
        JsonValueToDbEntityMapper mapper = new JsonValueToDbEntityMapper(jsonKeyNameReviser);
        return mapper::mapJsonObjectToBsonDocument;
    }

    public static Function<JsonArray, BsonArray> forJsonArray(Function<String, String> jsonKeyNameReviser) {
        JsonValueToDbEntityMapper mapper = new JsonValueToDbEntityMapper(jsonKeyNameReviser);
        return mapper::mapJsonArrayToBsonArray;
    }

    private String reviseKeyName(JsonKey jsonKey) {
        return this.jsonKeyNameReviser.apply(jsonKey.toString());
    }

    private BsonDocument mapJsonObjectToBsonDocument(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object to be mapped");
        BsonDocument result = new BsonDocument();
        jsonObject.forEach(jsonField -> result.put(this.reviseKeyName(jsonField.getKey()), this.mapJsonValueToBsonValue(jsonField.getValue())));
        return result;
    }

    private BsonArray mapJsonArrayToBsonArray(JsonArray jsonArray) {
        ConditionChecker.checkNotNull((Object)jsonArray, (String)"JSON array to be mapped");
        BsonArray result = new BsonArray();
        jsonArray.forEach(jsonValue -> result.add(this.mapJsonValueToBsonValue((JsonValue)jsonValue)));
        return result;
    }

    @Nullable
    private Object mapJsonValueToJavaObject(JsonValue jsonValue) {
        ConditionChecker.checkNotNull((Object)jsonValue, (String)"JSON value to be mapped");
        Object result = jsonValue.isNull() ? null : (jsonValue.isString() ? jsonValue.asString() : (jsonValue.isNumber() ? JsonValueToDbEntityMapper.mapJsonNumberToJavaNumber(jsonValue) : (jsonValue.isObject() ? this.mapJsonObjectToBsonDocument(jsonValue.asObject()) : (jsonValue.isArray() ? this.mapJsonArrayToBsonArray(jsonValue.asArray()) : (jsonValue.isBoolean() ? Boolean.valueOf(jsonValue.asBoolean()) : null)))));
        return result;
    }

    @Nullable
    private BsonValue mapJsonValueToBsonValue(JsonValue jsonValue) {
        ConditionChecker.checkNotNull((Object)jsonValue, (String)"JSON value to be mapped");
        Object result = jsonValue.isNull() ? BsonNull.VALUE : (jsonValue.isString() ? new BsonString(jsonValue.asString()) : (jsonValue.isNumber() ? JsonValueToDbEntityMapper.mapJsonNumberToBsonNumber(jsonValue) : (jsonValue.isObject() ? this.mapJsonObjectToBsonDocument(jsonValue.asObject()) : (jsonValue.isArray() ? this.mapJsonArrayToBsonArray(jsonValue.asArray()) : (jsonValue.isBoolean() ? BsonBoolean.valueOf((boolean)jsonValue.asBoolean()) : null)))));
        return result;
    }

    private static Number mapJsonNumberToJavaNumber(JsonValue jsonNumberValue) {
        Number result = jsonNumberValue.isInt() ? (Number)jsonNumberValue.asInt() : (Number)(jsonNumberValue.isLong() ? (Number)jsonNumberValue.asLong() : (Number)jsonNumberValue.asDouble());
        return result;
    }

    private static BsonNumber mapJsonNumberToBsonNumber(JsonValue jsonNumberValue) {
        Object result = jsonNumberValue.isInt() ? new BsonInt32(jsonNumberValue.asInt()) : (jsonNumberValue.isLong() ? new BsonInt64(jsonNumberValue.asLong()) : new BsonDouble(jsonNumberValue.asDouble()));
        return result;
    }
}

