/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;

@Immutable
final class KeyNameReviser
implements Function<String, String> {
    static final char DOLLAR_CHAR = '$';
    static final char DOLLAR_UNICODE_CHAR = '\uff04';
    static final char DOT_CHAR = '.';
    static final char DOT_UNICODE_CHAR = '\uff0e';
    private final Function<String, String> replaceFunction;

    private KeyNameReviser(Function<String, String> theReplaceFunction) {
        this.replaceFunction = theReplaceFunction;
    }

    public static KeyNameReviser getInstance(Function<String, String> replaceFunction) {
        return new KeyNameReviser((Function)ConditionChecker.checkNotNull(replaceFunction, (String)"replace function"));
    }

    public static KeyNameReviser escapeProblematicPlainChars() {
        return KeyNameReviser.getInstance(KeyNameReviser.replace('.', '\uff0e').andThen(KeyNameReviser.replace('$', '\uff04')));
    }

    public static KeyNameReviser decodeKnownUnicodeChars() {
        return KeyNameReviser.getInstance(KeyNameReviser.replace('\uff04', '$').andThen(KeyNameReviser.replace('\uff0e', '.')));
    }

    private static Function<String, String> replace(char oldChar, char charNewChar) {
        return s -> s.replace(oldChar, charNewChar);
    }

    @Override
    public String apply(String keyName) {
        ConditionChecker.checkNotNull((Object)keyName, (String)"key name to be revised");
        return this.replaceFunction.apply(keyName);
    }
}

