/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoMongoClient;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoMongoClientBuilder;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoMongoClientSettings;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;
import org.reactivestreams.Publisher;

@NotThreadSafe
public final class MongoClientWrapper
implements DittoMongoClient {
    private final MongoClient mongoClient;
    private final MongoClientSettings clientSettings;
    private final MongoDatabase defaultDatabase;
    private final DittoMongoClientSettings dittoMongoClientSettings;
    @Nullable
    private final EventLoopGroup eventLoopGroup;

    private MongoClientWrapper(MongoClientSettings clientSettings, String defaultDatabaseName, DittoMongoClientSettings theDittoMongoClientSettings, @Nullable EventLoopGroup theEventLoopGroup) {
        this.clientSettings = clientSettings;
        this.mongoClient = MongoClients.create((MongoClientSettings)clientSettings);
        this.defaultDatabase = this.mongoClient.getDatabase(defaultDatabaseName);
        this.dittoMongoClientSettings = theDittoMongoClientSettings;
        this.eventLoopGroup = theEventLoopGroup;
    }

    public static MongoClientWrapper newInstance(MongoDbConfig mongoDbConfig) {
        return (MongoClientWrapper)MongoClientWrapper.getBuilder(mongoDbConfig).build();
    }

    public static DittoMongoClientBuilder.ConnectionCoordinatesStep getBuilder() {
        return MongoClientWrapperBuilder.newInstance();
    }

    public static DittoMongoClientBuilder.GeneralPropertiesStep getBuilder(MongoDbConfig mongoDbConfig) {
        return MongoClientWrapperBuilder.newInstance(mongoDbConfig);
    }

    @Override
    public MongoDatabase getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Override
    public MongoCollection<Document> getCollection(CharSequence name) {
        return this.defaultDatabase.getCollection(((CharSequence)ConditionChecker.checkNotNull((Object)name, (String)"collection name")).toString());
    }

    @Override
    public DittoMongoClientSettings getDittoSettings() {
        return this.dittoMongoClientSettings;
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongoClient.getDatabase(name);
    }

    public Publisher<String> listDatabaseNames() {
        return this.mongoClient.listDatabaseNames();
    }

    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return this.mongoClient.listDatabaseNames(clientSession);
    }

    public ListDatabasesPublisher<Document> listDatabases() {
        return this.mongoClient.listDatabases();
    }

    public <TResult> ListDatabasesPublisher<TResult> listDatabases(Class<TResult> clazz) {
        return this.mongoClient.listDatabases(clazz);
    }

    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.mongoClient.listDatabases(clientSession);
    }

    public <TResult> ListDatabasesPublisher<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        return this.mongoClient.listDatabases(clientSession, clazz);
    }

    public ChangeStreamPublisher<Document> watch() {
        return this.mongoClient.watch();
    }

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> tResultClass) {
        return this.mongoClient.watch(tResultClass);
    }

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.mongoClient.watch(pipeline);
    }

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoClient.watch(pipeline, tResultClass);
    }

    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.mongoClient.watch(clientSession);
    }

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> tResultClass) {
        return this.mongoClient.watch(clientSession, tResultClass);
    }

    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.mongoClient.watch(clientSession, pipeline);
    }

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoClient.watch(clientSession, pipeline, tResultClass);
    }

    public Publisher<ClientSession> startSession() {
        return this.mongoClient.startSession();
    }

    public Publisher<ClientSession> startSession(ClientSessionOptions options) {
        return this.mongoClient.startSession(options);
    }

    @Override
    public MongoClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public ClusterDescription getClusterDescription() {
        return this.mongoClient.getClusterDescription();
    }

    public void close() {
        if (null != this.eventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
        this.mongoClient.close();
    }

    @NotThreadSafe
    static final class MongoClientWrapperBuilder
    implements DittoMongoClientBuilder,
    DittoMongoClientBuilder.ConnectionCoordinatesStep,
    DittoMongoClientBuilder.DatabaseNameStep,
    DittoMongoClientBuilder.GeneralPropertiesStep {
        private final MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder();
        private final DittoMongoClientSettings.Builder dittoMongoClientSettingsBuilder;
        @Nullable
        private ConnectionString connectionString;
        private String defaultDatabaseName;
        private boolean sslEnabled;
        @Nullable
        private EventLoopGroup eventLoopGroup;

        private MongoClientWrapperBuilder() {
            this.mongoClientSettingsBuilder.readPreference(ReadPreference.primaryPreferred());
            this.dittoMongoClientSettingsBuilder = DittoMongoClientSettings.getBuilder();
            this.connectionString = null;
            this.defaultDatabaseName = null;
            this.sslEnabled = false;
            this.eventLoopGroup = null;
        }

        static DittoMongoClientBuilder.ConnectionCoordinatesStep newInstance() {
            return new MongoClientWrapperBuilder();
        }

        static DittoMongoClientBuilder.GeneralPropertiesStep newInstance(MongoDbConfig mongoDbConfig) {
            ConditionChecker.checkNotNull((Object)mongoDbConfig, (String)"MongoDB config");
            MongoClientWrapperBuilder builder = new MongoClientWrapperBuilder();
            builder.maxQueryTime(mongoDbConfig.getMaxQueryTime());
            builder.connectionString(mongoDbConfig.getMongoDbUri());
            MongoDbConfig.ConnectionPoolConfig connectionPoolConfig = mongoDbConfig.getConnectionPoolConfig();
            builder.connectionPoolMinSize(connectionPoolConfig.getMinSize());
            builder.connectionPoolMaxSize(connectionPoolConfig.getMaxSize());
            builder.connectionPoolMaxWaitTime(connectionPoolConfig.getMaxWaitTime());
            builder.enableJmxListener(connectionPoolConfig.isJmxListenerEnabled());
            MongoDbConfig.OptionsConfig optionsConfig = mongoDbConfig.getOptionsConfig();
            builder.enableSsl(optionsConfig.isSslEnabled());
            builder.setReadPreference(optionsConfig.readPreference().getMongoReadPreference());
            builder.setReadConcern(optionsConfig.readConcern().getMongoReadConcern());
            builder.setWriteConcern(optionsConfig.writeConcern());
            builder.setRetryWrites(optionsConfig.isRetryWrites());
            return builder;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep connectionString(String string) {
            this.connectionString = new ConnectionString((String)ConditionChecker.checkNotNull((Object)string, (String)"connection string"));
            this.mongoClientSettingsBuilder.applyConnectionString(this.connectionString);
            this.defaultDatabaseName = this.connectionString.getDatabase();
            return this;
        }

        @Override
        public MongoClientWrapperBuilder enableSsl(boolean enabled) {
            this.sslEnabled = enabled;
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep maxQueryTime(@Nullable Duration maxQueryTime) {
            this.dittoMongoClientSettingsBuilder.maxQueryTime(maxQueryTime);
            return this;
        }

        @Override
        public DittoMongoClientBuilder.DatabaseNameStep hostnameAndPort(CharSequence hostname, int portNumber) {
            ConditionChecker.checkNotNull((Object)hostname, (String)"hostname");
            this.mongoClientSettingsBuilder.applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(hostname.toString(), portNumber))).build());
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep defaultDatabaseName(CharSequence databaseName) {
            this.defaultDatabaseName = ((CharSequence)ConditionChecker.checkNotNull((Object)databaseName, (String)"name of the default database")).toString();
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep connectionPoolMinSize(int minSize) {
            this.mongoClientSettingsBuilder.applyToConnectionPoolSettings(builder -> builder.minSize(minSize));
            return this;
        }

        @Override
        public MongoClientWrapperBuilder connectionPoolMaxSize(int maxSize) {
            this.mongoClientSettingsBuilder.applyToConnectionPoolSettings(builder -> builder.maxSize(maxSize));
            return this;
        }

        @Override
        public MongoClientWrapperBuilder connectionPoolMaxWaitTime(Duration maxPoolWaitTime) {
            ConditionChecker.checkNotNull((Object)maxPoolWaitTime, (String)"maxPoolWaitTime");
            this.mongoClientSettingsBuilder.applyToConnectionPoolSettings(builder -> builder.maxWaitTime(maxPoolWaitTime.toMillis(), TimeUnit.MILLISECONDS));
            return this;
        }

        @Override
        public MongoClientWrapperBuilder addCommandListener(@Nullable CommandListener commandListener) {
            if (null != commandListener) {
                this.mongoClientSettingsBuilder.addCommandListener(commandListener);
            }
            return this;
        }

        @Override
        public MongoClientWrapperBuilder enableJmxListener(boolean enabled) {
            if (enabled) {
                this.mongoClientSettingsBuilder.applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener((ConnectionPoolListener)new JMXConnectionPoolListener()));
            }
            return this;
        }

        @Override
        public MongoClientWrapperBuilder addConnectionPoolListener(@Nullable ConnectionPoolListener connectionPoolListener) {
            if (null != connectionPoolListener) {
                this.mongoClientSettingsBuilder.applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener(connectionPoolListener));
            }
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep setReadPreference(ReadPreference readPreference) {
            this.mongoClientSettingsBuilder.readPreference(readPreference);
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep setReadConcern(ReadConcern readConcern) {
            this.mongoClientSettingsBuilder.readConcern(readConcern);
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep setWriteConcern(WriteConcern writeConcern) {
            this.mongoClientSettingsBuilder.writeConcern(writeConcern);
            return this;
        }

        @Override
        public DittoMongoClientBuilder.GeneralPropertiesStep setRetryWrites(boolean retryWrites) {
            this.mongoClientSettingsBuilder.retryWrites(retryWrites);
            return this;
        }

        @Override
        public MongoClientWrapper build() {
            this.buildAndApplySslSettings();
            return new MongoClientWrapper(this.mongoClientSettingsBuilder.build(), this.defaultDatabaseName, this.dittoMongoClientSettingsBuilder.build(), this.eventLoopGroup);
        }

        private void buildAndApplySslSettings() {
            if (this.sslEnabled) {
                this.eventLoopGroup = new NioEventLoopGroup();
                this.mongoClientSettingsBuilder.streamFactoryFactory((StreamFactoryFactory)NettyStreamFactoryFactory.builder().eventLoopGroup(this.eventLoopGroup).build()).applyToSslSettings(builder -> builder.context(MongoClientWrapperBuilder.tryToCreateAndInitSslContext()).enabled(this.sslEnabled));
            } else if (null != this.connectionString) {
                this.eventLoopGroup = null;
                this.mongoClientSettingsBuilder.applyToSslSettings(builder -> builder.enabled(this.sslEnabled));
            }
        }

        private static SSLContext tryToCreateAndInitSslContext() {
            try {
                return MongoClientWrapperBuilder.createAndInitSslContext();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("No such Algorithm is supported!", e);
            }
            catch (KeyManagementException e) {
                throw new IllegalStateException("KeyManagementException!", e);
            }
        }

        private static SSLContext createAndInitSslContext() throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext result = SSLContext.getInstance("TLSv1.2");
            result.init(null, null, null);
            return result;
        }
    }
}

