/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.function.Function;
import akka.japi.pf.ReceiveBuilder;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.bson.Document;
import org.eclipse.ditto.internal.utils.config.DefaultScopedConfig;
import org.eclipse.ditto.internal.utils.health.AbstractHealthCheckingActor;
import org.eclipse.ditto.internal.utils.health.StatusInfo;
import org.eclipse.ditto.internal.utils.health.mongo.CurrentMongoStatus;
import org.eclipse.ditto.internal.utils.persistence.mongo.DittoMongoClient;
import org.eclipse.ditto.internal.utils.persistence.mongo.MongoClientWrapper;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultMongoDbConfig;
import org.reactivestreams.Publisher;

public final class MongoHealthChecker
extends AbstractHealthCheckingActor {
    private static final String TEST_COLLECTION_NAME = "test";
    private static final String ID_FIELD = "_id";
    private static final int HEALTH_CHECK_MAX_POOL_SIZE = 2;
    private final DittoMongoClient mongoClient;
    private final MongoCollection<Document> collection;
    private final Materializer materializer;

    private MongoHealthChecker() {
        DefaultMongoDbConfig mongoDbConfig = DefaultMongoDbConfig.of((Config)DefaultScopedConfig.dittoScoped((Config)this.getContext().getSystem().settings().config()));
        this.mongoClient = MongoClientWrapper.getBuilder(mongoDbConfig).connectionPoolMinSize(0).connectionPoolMaxSize(2).build();
        this.collection = this.mongoClient.getCollection(TEST_COLLECTION_NAME).withReadPreference(ReadPreference.primary()).withReadConcern(ReadConcern.LOCAL).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.materializer = Materializer.createMaterializer(() -> ((MongoHealthChecker)this).getContext());
    }

    public void postStop() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public static Props props() {
        return Props.create(MongoHealthChecker.class, (Object[])new Object[0]);
    }

    protected AbstractActor.Receive matchCustomMessages() {
        return ReceiveBuilder.create().match(CurrentMongoStatus.class, this::applyMongoStatus).build();
    }

    protected void triggerHealthRetrieval() {
        this.generateStatusResponse().thenAccept(errorOpt -> {
            CurrentMongoStatus mongoStatus;
            if (errorOpt.isPresent()) {
                Throwable error = (Throwable)errorOpt.get();
                mongoStatus = new CurrentMongoStatus(false, error.getClass().getCanonicalName() + ": " + error.getMessage());
                this.log.error(error, error.getMessage());
            } else {
                mongoStatus = new CurrentMongoStatus(true);
            }
            this.getSelf().tell((Object)mongoStatus, ActorRef.noSender());
        });
    }

    private CompletionStage<Optional<Throwable>> generateStatusResponse() {
        String id = UUID.randomUUID().toString();
        return ((CompletionStage)Source.fromPublisher((Publisher)this.collection.insertOne((Object)new Document(ID_FIELD, (Object)id))).flatMapConcat((Function & Serializable)s -> Source.fromPublisher((Publisher)this.collection.find(Filters.eq((String)ID_FIELD, (Object)id))).flatMapConcat((Function & Serializable)r -> Source.fromPublisher((Publisher)this.collection.deleteOne(Filters.eq((String)ID_FIELD, (Object)id))).map(DeleteResult::getDeletedCount))).runWith((Graph)Sink.seq(), this.materializer)).handle((result, error) -> {
            if (error != null) {
                return Optional.of(error);
            }
            if (!Objects.equals(result, Collections.singletonList(1L))) {
                String message = "Expect 1 document inserted and deleted. Found: " + result;
                this.log.error(message);
                return Optional.of(new IllegalStateException(message));
            }
            return Optional.empty();
        });
    }

    private void applyMongoStatus(CurrentMongoStatus status) {
        StatusInfo persistenceStatus = StatusInfo.fromStatus((StatusInfo.Status)(status.isAlive() ? StatusInfo.Status.UP : StatusInfo.Status.DOWN), (String)status.getDescription().orElse(null));
        this.updateHealth(persistenceStatus);
    }
}

