/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;

public final class MongoMetrics
implements Jsonifiable<JsonObject> {
    private final String reporter;
    private final Duration resolution;
    private final List<Long> maxTimerNanos;

    private MongoMetrics(String reporter, Duration resolution, List<Long> maxTimerNanos) {
        this.reporter = reporter;
        this.resolution = resolution;
        this.maxTimerNanos = Collections.unmodifiableList(new ArrayList<Long>(maxTimerNanos));
    }

    public static MongoMetrics of(String reporter, Duration resolution, Iterable<Long> maxTimerNanos) {
        ArrayList<Long> target = new ArrayList<Long>();
        maxTimerNanos.forEach(target::add);
        return new MongoMetrics(reporter, resolution, target);
    }

    public static MongoMetrics fromJson(String jsonString) {
        return MongoMetrics.fromJson(JsonFactory.newObject((String)jsonString));
    }

    public static MongoMetrics fromJson(JsonObject jsonObject) {
        String extractedReporter = (String)jsonObject.getValueOrThrow(JsonFields.REPORTER);
        Duration extractedResolution = Duration.parse((CharSequence)jsonObject.getValueOrThrow(JsonFields.RESOLUTION));
        List<Long> extractedMaxTimerNanos = jsonObject.getValue(JsonFields.MAX_TIMER_NANOS).orElse(JsonArray.empty()).stream().filter(JsonValue::isLong).map(JsonValue::asLong).collect(Collectors.toList());
        return MongoMetrics.of(extractedReporter, extractedResolution, extractedMaxTimerNanos);
    }

    public String getReporter() {
        return this.reporter;
    }

    public Duration getResolution() {
        return this.resolution;
    }

    public List<Long> getMaxTimerNanos() {
        return this.maxTimerNanos;
    }

    public JsonObject toJson() {
        return JsonFactory.newObjectBuilder().set(JsonFields.REPORTER, (Object)this.reporter).set(JsonFields.RESOLUTION, (Object)this.resolution.toString()).set(JsonFields.MAX_TIMER_NANOS, (Object)((JsonArray)this.maxTimerNanos.stream().map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray()))).build();
    }

    @Immutable
    public static final class JsonFields {
        static final JsonFieldDefinition<String> REPORTER = JsonFactory.newStringFieldDefinition((CharSequence)"reporter", (JsonFieldMarker[])new JsonFieldMarker[0]);
        static final JsonFieldDefinition<String> RESOLUTION = JsonFactory.newStringFieldDefinition((CharSequence)"resolution", (JsonFieldMarker[])new JsonFieldMarker[0]);
        static final JsonFieldDefinition<JsonArray> MAX_TIMER_NANOS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"maxTimerNanos", (JsonFieldMarker[])new JsonFieldMarker[0]);

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

