/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.japi.pf.ReceiveBuilder;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.eclipse.ditto.internal.utils.cluster.DistPubSubAccess;
import org.eclipse.ditto.internal.utils.health.AbstractHealthCheckingActor;
import org.eclipse.ditto.internal.utils.health.StatusDetailMessage;
import org.eclipse.ditto.internal.utils.health.StatusInfo;
import org.eclipse.ditto.internal.utils.metrics.mongo.MongoMetricsBuilder;
import org.eclipse.ditto.internal.utils.persistence.mongo.MongoMetrics;
import org.eclipse.ditto.json.JsonValue;

public final class MongoMetricsReporter
extends AbstractHealthCheckingActor {
    public static final String PUBSUB_TOPIC = MongoMetricsReporter.class.getSimpleName();
    private static final Tick TICK = new Tick();
    private final Duration resolution;
    private final int history;
    private final Deque<Long> maxTimerNanos;

    private MongoMetricsReporter(Duration resolution, int history, ActorRef pubSubMediator) {
        this.resolution = resolution;
        this.history = Math.max(1, history);
        this.maxTimerNanos = new ArrayDeque<Long>(history);
        this.getTimers().startPeriodicTimer((Object)TICK, (Object)TICK, resolution);
        this.subscribeForTopicWithoutGroup(pubSubMediator);
    }

    public static Props props(Duration resolution, int history, ActorRef pubSubMediator) {
        return Props.create(MongoMetricsReporter.class, (Object[])new Object[]{resolution, history, pubSubMediator});
    }

    protected AbstractActor.Receive matchCustomMessages() {
        return ReceiveBuilder.create().matchEquals((Object)TICK, this::tick).match(DistributedPubSubMediator.SubscribeAck.class, this::subscribeAck).build();
    }

    protected void triggerHealthRetrieval() {
        this.updateHealth(this.renderStatusInfo());
    }

    private StatusInfo renderStatusInfo() {
        return StatusInfo.fromStatus((StatusInfo.Status)StatusInfo.Status.UP, Collections.singletonList(this.renderStatusDetailMessage()));
    }

    private StatusDetailMessage renderStatusDetailMessage() {
        return StatusDetailMessage.of((StatusDetailMessage.Level)StatusDetailMessage.Level.INFO, (JsonValue)this.getMetrics().toJson());
    }

    private MongoMetrics getMetrics() {
        return MongoMetrics.of(this.getSelf().path().toStringWithoutAddress(), this.resolution, this.maxTimerNanos);
    }

    private void tick(Tick trigger) {
        long nanos = MongoMetricsBuilder.maxTimerNanos().getThenReset();
        if (this.maxTimerNanos.size() >= this.history) {
            this.maxTimerNanos.removeLast();
        }
        this.maxTimerNanos.addFirst(nanos);
    }

    private void subscribeForTopicWithoutGroup(ActorRef pubSubMediator) {
        DistributedPubSubMediator.Subscribe subscribe = DistPubSubAccess.subscribe((String)PUBSUB_TOPIC, (ActorRef)this.getSelf());
        pubSubMediator.tell((Object)subscribe, this.getSelf());
    }

    private void subscribeAck(DistributedPubSubMediator.SubscribeAck subscribeAck) {
        this.log.info("Subscribed: {}", (Object)subscribeAck.subscribe());
    }

    private static final class Tick {
        private Tick() {
        }
    }
}

