/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.ActivityCheckConfig;

@Immutable
public final class DefaultActivityCheckConfig
implements ActivityCheckConfig {
    private static final String CONFIG_PATH = "activity-check";
    private final Duration inactiveInterval;
    private final Duration deletedInterval;

    private DefaultActivityCheckConfig(ScopedConfig scopedConfig) {
        this.inactiveInterval = scopedConfig.getDuration(ActivityCheckConfig.ActivityCheckConfigValue.INACTIVE_INTERVAL.getConfigPath());
        this.deletedInterval = scopedConfig.getDuration(ActivityCheckConfig.ActivityCheckConfigValue.DELETED_INTERVAL.getConfigPath());
    }

    public static DefaultActivityCheckConfig of(Config config) {
        return new DefaultActivityCheckConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])ActivityCheckConfig.ActivityCheckConfigValue.values()));
    }

    @Override
    public Duration getInactiveInterval() {
        return this.inactiveInterval;
    }

    @Override
    public Duration getDeletedInterval() {
        return this.deletedInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultActivityCheckConfig that = (DefaultActivityCheckConfig)o;
        return Objects.equals(this.inactiveInterval, that.inactiveInterval) && Objects.equals(this.deletedInterval, that.deletedInterval);
    }

    public int hashCode() {
        return Objects.hash(this.inactiveInterval, this.deletedInterval);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [inactiveInterval=" + this.inactiveInterval + ", deletedInterval=" + this.deletedInterval + "]";
    }
}

