/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultTimeoutConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;

@Immutable
public final class DefaultCircuitBreakerConfig
implements MongoDbConfig.CircuitBreakerConfig {
    private static final String CONFIG_PATH = "breaker";
    private final int maxFailures;
    private final MongoDbConfig.CircuitBreakerConfig.TimeoutConfig timeoutConfig;

    private DefaultCircuitBreakerConfig(ScopedConfig config) {
        this.maxFailures = config.getInt(MongoDbConfig.CircuitBreakerConfig.CircuitBreakerConfigValue.MAX_FAILURES.getConfigPath());
        this.timeoutConfig = DefaultTimeoutConfig.of((Config)config);
    }

    public static DefaultCircuitBreakerConfig of(Config config) {
        return new DefaultCircuitBreakerConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.CircuitBreakerConfig.CircuitBreakerConfigValue.values()));
    }

    @Override
    public int getMaxFailures() {
        return this.maxFailures;
    }

    @Override
    public MongoDbConfig.CircuitBreakerConfig.TimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCircuitBreakerConfig that = (DefaultCircuitBreakerConfig)o;
        return this.maxFailures == that.maxFailures && Objects.equals(this.timeoutConfig, that.timeoutConfig);
    }

    public int hashCode() {
        return Objects.hash(this.maxFailures, this.timeoutConfig);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [maxFailures=" + this.maxFailures + ", timeoutConfig=" + this.timeoutConfig + "]";
    }
}

