/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;

@Immutable
public final class DefaultConnectionPoolConfig
implements MongoDbConfig.ConnectionPoolConfig {
    private static final String CONFIG_PATH = "pool";
    private final int minSize;
    private final int maxSize;
    private final Duration maxWaitTime;
    private final boolean jmxListenerEnabled;

    private DefaultConnectionPoolConfig(ScopedConfig config) {
        this.minSize = config.getInt(MongoDbConfig.ConnectionPoolConfig.ConnectionPoolConfigValue.MIN_SIZE.getConfigPath());
        this.maxSize = config.getInt(MongoDbConfig.ConnectionPoolConfig.ConnectionPoolConfigValue.MAX_SIZE.getConfigPath());
        this.maxWaitTime = config.getDuration(MongoDbConfig.ConnectionPoolConfig.ConnectionPoolConfigValue.MAX_WAIT_TIME.getConfigPath());
        this.jmxListenerEnabled = config.getBoolean(MongoDbConfig.ConnectionPoolConfig.ConnectionPoolConfigValue.JMX_LISTENER_ENABLED.getConfigPath());
    }

    public static DefaultConnectionPoolConfig of(Config config) {
        return new DefaultConnectionPoolConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.ConnectionPoolConfig.ConnectionPoolConfigValue.values()));
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public Duration getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Override
    public boolean isJmxListenerEnabled() {
        return this.jmxListenerEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConnectionPoolConfig that = (DefaultConnectionPoolConfig)o;
        return this.minSize == that.minSize && this.maxSize == that.maxSize && this.jmxListenerEnabled == that.jmxListenerEnabled && Objects.equals(this.maxWaitTime, that.maxWaitTime);
    }

    public int hashCode() {
        return Objects.hash(this.minSize, this.maxSize, this.maxWaitTime, this.jmxListenerEnabled);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", maxWaitTime=" + this.maxWaitTime + ", jmxListenerEnabled=" + this.jmxListenerEnabled + "]";
    }
}

