/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.util.Objects;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.IndexInitializationConfig;

public final class DefaultIndexInitializationConfig
implements IndexInitializationConfig {
    private static final String CONFIG_PATH = "index-initialization";
    private final boolean indexInitializationEnabled;

    private DefaultIndexInitializationConfig(ScopedConfig config) {
        this.indexInitializationEnabled = config.getBoolean(IndexInitializationConfig.IndexInitializerConfigValue.ENABLED.getConfigPath());
    }

    public static DefaultIndexInitializationConfig of(Config config) {
        return new DefaultIndexInitializationConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])IndexInitializationConfig.IndexInitializerConfigValue.values()));
    }

    @Override
    public boolean isIndexInitializationConfigEnabled() {
        return this.indexInitializationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIndexInitializationConfig that = (DefaultIndexInitializationConfig)o;
        return Objects.equals(this.indexInitializationEnabled, that.indexInitializationEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.indexInitializationEnabled);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [indexInitializationEnabled=" + this.indexInitializationEnabled + "]";
    }
}

