/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultCircuitBreakerConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultConnectionPoolConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultMonitoringConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.DefaultOptionsConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbUriSupplier;

@Immutable
public final class DefaultMongoDbConfig
implements MongoDbConfig {
    static final String CONFIG_PATH = "mongodb";
    private final String mongoDbUri;
    private final Duration maxQueryTime;
    private final DefaultOptionsConfig optionsConfig;
    private final DefaultConnectionPoolConfig connectionPoolConfig;
    private final DefaultCircuitBreakerConfig circuitBreakerConfig;
    private final DefaultMonitoringConfig monitoringConfig;

    private DefaultMongoDbConfig(ConfigWithFallback config) {
        Map<String, Object> extraUriOptions;
        this.maxQueryTime = config.getDuration(MongoDbConfig.MongoDbConfigValue.MAX_QUERY_TIME.getConfigPath());
        this.optionsConfig = DefaultOptionsConfig.of((Config)config);
        String configuredUri = config.getString(MongoDbConfig.MongoDbConfigValue.URI.getConfigPath());
        Map<String, Object> configuredExtraUriOptions = this.optionsConfig.extraUriOptions();
        String sslKey = MongoDbConfig.OptionsConfig.OptionsConfigValue.SSL_ENABLED.getConfigPath();
        if (configuredExtraUriOptions.containsKey(sslKey)) {
            extraUriOptions = configuredExtraUriOptions;
        } else {
            extraUriOptions = new HashMap<String, Object>(configuredExtraUriOptions);
            extraUriOptions.put(sslKey, this.optionsConfig.isSslEnabled());
        }
        this.mongoDbUri = DefaultMongoDbConfig.determineMongoDbUri(configuredUri, extraUriOptions);
        this.connectionPoolConfig = DefaultConnectionPoolConfig.of((Config)config);
        this.circuitBreakerConfig = DefaultCircuitBreakerConfig.of((Config)config);
        this.monitoringConfig = DefaultMonitoringConfig.of((Config)config);
    }

    public static DefaultMongoDbConfig of(Config config) {
        ConfigWithFallback configWithFallback = DefaultMongoDbConfig.appendFallbackValues(config);
        return new DefaultMongoDbConfig(configWithFallback);
    }

    private static ConfigWithFallback appendFallbackValues(Config config) {
        return ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.MongoDbConfigValue.values());
    }

    private static String determineMongoDbUri(String configuredMongoUri, Map<String, Object> extraUriOptions) {
        MongoDbUriSupplier mongoDbUriSupplier = MongoDbUriSupplier.of(configuredMongoUri, extraUriOptions);
        return mongoDbUriSupplier.get();
    }

    @Override
    public String getMongoDbUri() {
        return this.mongoDbUri;
    }

    @Override
    public Duration getMaxQueryTime() {
        return this.maxQueryTime;
    }

    @Override
    public MongoDbConfig.OptionsConfig getOptionsConfig() {
        return this.optionsConfig;
    }

    @Override
    public MongoDbConfig.ConnectionPoolConfig getConnectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    @Override
    public MongoDbConfig.CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public MongoDbConfig.MonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMongoDbConfig that = (DefaultMongoDbConfig)o;
        return Objects.equals(this.mongoDbUri, that.mongoDbUri) && Objects.equals(this.maxQueryTime, that.maxQueryTime) && Objects.equals(this.optionsConfig, that.optionsConfig) && Objects.equals(this.connectionPoolConfig, that.connectionPoolConfig) && Objects.equals(this.circuitBreakerConfig, that.circuitBreakerConfig) && Objects.equals(this.monitoringConfig, that.monitoringConfig);
    }

    public int hashCode() {
        return Objects.hash(this.mongoDbUri, this.maxQueryTime, this.optionsConfig, this.connectionPoolConfig, this.circuitBreakerConfig, this.monitoringConfig);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [mongoDbUri=" + this.mongoDbUri + ", maxQueryTime=" + this.maxQueryTime + ", optionsConfig=" + this.optionsConfig + ", connectionPoolConfig=" + this.connectionPoolConfig + ", circuitBreakerConfig=" + this.circuitBreakerConfig + ", monitoringConfig=" + this.monitoringConfig + "]";
    }
}

