/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;

@Immutable
public final class DefaultMonitoringConfig
implements MongoDbConfig.MonitoringConfig {
    private static final String CONFIG_PATH = "monitoring";
    private final boolean commandsEnabled;
    private final boolean connectionPoolEnabled;

    private DefaultMonitoringConfig(ScopedConfig config) {
        this.commandsEnabled = config.getBoolean(MongoDbConfig.MonitoringConfig.MonitoringConfigValue.COMMANDS_ENABLED.getConfigPath());
        this.connectionPoolEnabled = config.getBoolean(MongoDbConfig.MonitoringConfig.MonitoringConfigValue.CONNECTION_POOL_ENABLED.getConfigPath());
    }

    public static DefaultMonitoringConfig of(Config config) {
        return new DefaultMonitoringConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.MonitoringConfig.MonitoringConfigValue.values()));
    }

    @Override
    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }

    @Override
    public boolean isConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMonitoringConfig that = (DefaultMonitoringConfig)o;
        return this.commandsEnabled == that.commandsEnabled && this.connectionPoolEnabled == that.connectionPoolEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.commandsEnabled, this.connectionPoolEnabled);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [commandsEnabled=" + this.commandsEnabled + ", connectionPoolEnabled=" + this.connectionPoolEnabled + "]";
    }
}

