/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.mongodb.WriteConcern;
import com.typesafe.config.Config;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.DittoConfigError;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.ReadConcern;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.ReadPreference;

@Immutable
public final class DefaultOptionsConfig
implements MongoDbConfig.OptionsConfig {
    static final String CONFIG_PATH = "options";
    private final boolean sslEnabled;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Map<String, Object> extraUriOptions;

    private DefaultOptionsConfig(ScopedConfig config) {
        this.sslEnabled = config.getBoolean(MongoDbConfig.OptionsConfig.OptionsConfigValue.SSL_ENABLED.getConfigPath());
        String readPreferenceString = config.getString(MongoDbConfig.OptionsConfig.OptionsConfigValue.READ_PREFERENCE.getConfigPath());
        this.readPreference = ReadPreference.ofReadPreference(readPreferenceString).orElseThrow(() -> {
            String msg = MessageFormat.format("Could not parse a ReadPreference from configured string <{0}>", readPreferenceString);
            return new DittoConfigError(msg);
        });
        String readConcernString = config.getString(MongoDbConfig.OptionsConfig.OptionsConfigValue.READ_CONCERN.getConfigPath());
        this.readConcern = ReadConcern.ofReadConcern(readConcernString).orElseThrow(() -> {
            String msg = MessageFormat.format("Could not parse a ReadConcern from configured string <{0}>", readConcernString);
            return new DittoConfigError(msg);
        });
        String writeConcernString = config.getString(MongoDbConfig.OptionsConfig.OptionsConfigValue.WRITE_CONCERN.getConfigPath());
        this.writeConcern = Optional.ofNullable(WriteConcern.valueOf((String)writeConcernString)).orElseThrow(() -> {
            String msg = MessageFormat.format("Could not parse a WriteConcern from configured string <{0}>", writeConcernString);
            return new DittoConfigError(msg);
        });
        this.retryWrites = config.getBoolean(MongoDbConfig.OptionsConfig.OptionsConfigValue.RETRY_WRITES.getConfigPath());
        this.extraUriOptions = Collections.unmodifiableMap(new HashMap<String, Object>(DefaultOptionsConfig.configToMap(config.getConfig(MongoDbConfig.OptionsConfig.OptionsConfigValue.EXTRA_URI_OPTIONS.getConfigPath()))));
    }

    public static DefaultOptionsConfig of(Config config) {
        return new DefaultOptionsConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.OptionsConfig.OptionsConfigValue.values()));
    }

    private static Map<String, Object> configToMap(Config config) {
        return config.root().unwrapped();
    }

    @Override
    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public ReadPreference readPreference() {
        return this.readPreference;
    }

    @Override
    public ReadConcern readConcern() {
        return this.readConcern;
    }

    @Override
    public WriteConcern writeConcern() {
        return this.writeConcern;
    }

    @Override
    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    @Override
    public Map<String, Object> extraUriOptions() {
        return this.extraUriOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOptionsConfig that = (DefaultOptionsConfig)o;
        return this.sslEnabled == that.sslEnabled && this.retryWrites == that.retryWrites && this.readPreference == that.readPreference && this.readConcern == that.readConcern && Objects.equals(this.writeConcern, that.writeConcern) && Objects.equals(this.extraUriOptions, that.extraUriOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sslEnabled, this.readPreference, this.readConcern, this.writeConcern, this.retryWrites, this.extraUriOptions});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [sslEnabled=" + this.sslEnabled + ", readPreference=" + this.readPreference + ", readConcern=" + this.readConcern + ", writeConcern=" + this.writeConcern + ", retryWrites=" + this.retryWrites + ", extraUriOptions=" + this.extraUriOptions + "]";
    }
}

