/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.DittoConfigError;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.SnapshotConfig;

@Immutable
public final class DefaultSnapshotConfig
implements SnapshotConfig {
    private static final String CONFIG_PATH = "snapshot";
    private final Duration interval;
    private final long threshold;

    private DefaultSnapshotConfig(ScopedConfig config) {
        this.interval = config.getDuration(SnapshotConfig.SnapshotConfigValue.INTERVAL.getConfigPath());
        this.threshold = DefaultSnapshotConfig.getThreshold(config);
    }

    private static long getThreshold(ScopedConfig config) {
        long result = config.getLong(SnapshotConfig.SnapshotConfigValue.THRESHOLD.getConfigPath());
        if (1L > result) {
            String msgPattern = "The snapshot threshold must be positive but it was <{0}>!";
            throw new DittoConfigError(MessageFormat.format("The snapshot threshold must be positive but it was <{0}>!", result));
        }
        return result;
    }

    public static DefaultSnapshotConfig of(Config config) {
        return new DefaultSnapshotConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])SnapshotConfig.SnapshotConfigValue.values()));
    }

    @Override
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public long getThreshold() {
        return this.threshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSnapshotConfig that = (DefaultSnapshotConfig)o;
        return this.threshold == that.threshold && Objects.equals(this.interval, that.interval);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.threshold);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [interval=" + this.interval + ", threshold=" + this.threshold + "]";
    }
}

