/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.TagsConfig;

@Immutable
public final class DefaultTagsConfig
implements TagsConfig {
    private static final String CONFIG_PATH = "tags";
    private final int streamingCacheSize;

    private DefaultTagsConfig(Config config) {
        this.streamingCacheSize = config.getInt(TagsConfig.TagsConfigValue.STREAMING_CACHE_SIZE.getConfigPath());
    }

    public static DefaultTagsConfig of(Config config) {
        return new DefaultTagsConfig((Config)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])TagsConfig.TagsConfigValue.values()));
    }

    @Override
    public int getStreamingCacheSize() {
        return this.streamingCacheSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTagsConfig that = (DefaultTagsConfig)o;
        return this.streamingCacheSize == that.streamingCacheSize;
    }

    public int hashCode() {
        return Objects.hash(this.streamingCacheSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingCacheSize=" + this.streamingCacheSize + "]";
    }
}

