/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.config.ScopedConfig;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.MongoDbConfig;

@Immutable
public final class DefaultTimeoutConfig
implements MongoDbConfig.CircuitBreakerConfig.TimeoutConfig {
    private static final String CONFIG_PATH = "timeout";
    private final Duration call;
    private final Duration reset;

    private DefaultTimeoutConfig(ScopedConfig config) {
        this.call = config.getDuration(MongoDbConfig.CircuitBreakerConfig.TimeoutConfig.TimeoutConfigValue.CALL.getConfigPath());
        this.reset = config.getDuration(MongoDbConfig.CircuitBreakerConfig.TimeoutConfig.TimeoutConfigValue.RESET.getConfigPath());
    }

    public static DefaultTimeoutConfig of(Config config) {
        return new DefaultTimeoutConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])MongoDbConfig.CircuitBreakerConfig.TimeoutConfig.TimeoutConfigValue.values()));
    }

    @Override
    public Duration getCall() {
        return this.call;
    }

    @Override
    public Duration getReset() {
        return this.reset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTimeoutConfig that = (DefaultTimeoutConfig)o;
        return Objects.equals(this.call, that.call) && Objects.equals(this.reset, that.reset);
    }

    public int hashCode() {
        return Objects.hash(this.call, this.reset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [call=" + this.call + ", reset=" + this.reset + "]";
    }
}

