/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import com.mongodb.WriteConcern;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.ReadConcern;
import org.eclipse.ditto.internal.utils.persistence.mongo.config.ReadPreference;

@Immutable
public interface MongoDbConfig {
    public String getMongoDbUri();

    public Duration getMaxQueryTime();

    public OptionsConfig getOptionsConfig();

    public ConnectionPoolConfig getConnectionPoolConfig();

    public CircuitBreakerConfig getCircuitBreakerConfig();

    public MonitoringConfig getMonitoringConfig();

    @Immutable
    public static interface MonitoringConfig {
        public boolean isCommandsEnabled();

        public boolean isConnectionPoolEnabled();

        public static enum MonitoringConfigValue implements KnownConfigValue
        {
            COMMANDS_ENABLED("commands", false),
            CONNECTION_POOL_ENABLED("connection-pool", false);

            private final String path;
            private final Object defaultValue;

            private MonitoringConfigValue(String thePath, Object theDefaultValue) {
                this.path = thePath;
                this.defaultValue = theDefaultValue;
            }

            public String getConfigPath() {
                return this.path;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    @Immutable
    public static interface CircuitBreakerConfig {
        public int getMaxFailures();

        public TimeoutConfig getTimeoutConfig();

        @Immutable
        public static interface TimeoutConfig {
            public Duration getCall();

            public Duration getReset();

            public static enum TimeoutConfigValue implements KnownConfigValue
            {
                CALL("call", "5s"),
                RESET("reset", "10s");

                private final String path;
                private final Object defaultValue;

                private TimeoutConfigValue(String thePath, Object theDefaultValue) {
                    this.path = thePath;
                    this.defaultValue = theDefaultValue;
                }

                public String getConfigPath() {
                    return this.path;
                }

                public Object getDefaultValue() {
                    return this.defaultValue;
                }
            }
        }

        public static enum CircuitBreakerConfigValue implements KnownConfigValue
        {
            MAX_FAILURES("maxFailures", 5);

            private final String path;
            private final Object defaultValue;

            private CircuitBreakerConfigValue(String thePath, Object theDefaultValue) {
                this.path = thePath;
                this.defaultValue = theDefaultValue;
            }

            public String getConfigPath() {
                return this.path;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    @Immutable
    public static interface ConnectionPoolConfig {
        public int getMinSize();

        public int getMaxSize();

        public Duration getMaxWaitTime();

        public boolean isJmxListenerEnabled();

        public static enum ConnectionPoolConfigValue implements KnownConfigValue
        {
            MIN_SIZE("minSize", 0),
            MAX_SIZE("maxSize", 100),
            MAX_WAIT_TIME("maxWaitTime", Duration.ofSeconds(30L)),
            JMX_LISTENER_ENABLED("jmxListenerEnabled", false);

            private final String path;
            private final Object defaultValue;

            private ConnectionPoolConfigValue(String thePath, Object theDefaultValue) {
                this.path = thePath;
                this.defaultValue = theDefaultValue;
            }

            public String getConfigPath() {
                return this.path;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    @Immutable
    public static interface OptionsConfig {
        public boolean isSslEnabled();

        public ReadPreference readPreference();

        public ReadConcern readConcern();

        public WriteConcern writeConcern();

        public boolean isRetryWrites();

        public Map<String, Object> extraUriOptions();

        public static enum OptionsConfigValue implements KnownConfigValue
        {
            SSL_ENABLED("ssl", false),
            READ_PREFERENCE("readPreference", "primaryPreferred"),
            READ_CONCERN("readConcern", "default"),
            WRITE_CONCERN("writeConcern", "acknowledged"),
            RETRY_WRITES("retryWrites", true),
            EXTRA_URI_OPTIONS("extra-uri-options", Collections.emptyMap());

            private final String path;
            private final Object defaultValue;

            private OptionsConfigValue(String thePath, Object theDefaultValue) {
                this.path = thePath;
                this.defaultValue = theDefaultValue;
            }

            public String getConfigPath() {
                return this.path;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    public static enum MongoDbConfigValue implements KnownConfigValue
    {
        URI("uri", null),
        MAX_QUERY_TIME("maxQueryTime", Duration.ofMinutes(1L));

        private final String path;
        private final Object defaultValue;

        private MongoDbConfigValue(String thePath, Object theDefaultValue) {
            this.path = thePath;
            this.defaultValue = theDefaultValue;
        }

        public String getConfigPath() {
            return this.path;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

