/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.config.DittoConfigError;

@Immutable
final class MongoDbUriSupplier
implements Supplier<String> {
    static final String URI_CONFIG_PATH = "uri";
    private final URI mongoDbSourceUri;
    private final Map<String, Object> extraUriOptions;

    private MongoDbUriSupplier(URI mongoDbSourceUri, Map<String, Object> extraUriOptions) {
        this.mongoDbSourceUri = mongoDbSourceUri;
        this.extraUriOptions = Collections.unmodifiableMap(new HashMap<String, Object>(extraUriOptions));
    }

    static MongoDbUriSupplier of(String configuredMongoUri, Map<String, Object> extraUriOptions) {
        try {
            ConditionChecker.checkNotNull((Object)configuredMongoUri, (String)"configuredMongoUri");
            ConditionChecker.checkNotNull(extraUriOptions, (String)"extraUriOptions");
        }
        catch (NullPointerException e) {
            throw new DittoConfigError(e.getMessage(), (Throwable)e);
        }
        return new MongoDbUriSupplier(MongoDbUriSupplier.tryToGetMongoDbSourceUri(configuredMongoUri), extraUriOptions);
    }

    private static URI tryToGetMongoDbSourceUri(String mongoDbUriString) {
        try {
            return new URI(mongoDbUriString);
        }
        catch (URISyntaxException e) {
            String msgTemplate = "The configured MongoDB URI <{0}> is invalid!";
            throw new DittoConfigError(MessageFormat.format("The configured MongoDB URI <{0}> is invalid!", mongoDbUriString), (Throwable)e);
        }
    }

    @Override
    public String get() {
        URI targetUri = this.tryToCreateMongoDbTargetUri();
        return targetUri.toASCIIString();
    }

    private URI tryToCreateMongoDbTargetUri() {
        try {
            return this.createMongoDbTargetUri();
        }
        catch (URISyntaxException e) {
            String msgTemplate = "Failed to create MongoDB URI based on <{0}>!";
            throw new DittoConfigError(MessageFormat.format("Failed to create MongoDB URI based on <{0}>!", this.mongoDbSourceUri), (Throwable)e);
        }
    }

    private URI createMongoDbTargetUri() throws URISyntaxException {
        return new URI(this.mongoDbSourceUri.getScheme(), this.mongoDbSourceUri.getAuthority(), this.mongoDbSourceUri.getPath(), this.getTargetQueryComponent(), this.mongoDbSourceUri.getFragment());
    }

    @Nullable
    private String getTargetQueryComponent() {
        return MongoDbUriEnhancer.of(this.extraUriOptions).apply(this.mongoDbSourceUri);
    }

    @Immutable
    static final class QueryComponentParser
    implements Function<String, Map<String, String>> {
        private static final QueryComponentParser INSTANCE = new QueryComponentParser();

        private QueryComponentParser() {
        }

        static QueryComponentParser getInstance() {
            return INSTANCE;
        }

        @Override
        public Map<String, String> apply(@Nullable String queryComponent) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (null == queryComponent) {
                return result;
            }
            for (String queryParameter : queryComponent.split("&")) {
                int assignmentDelimiterIndex = queryParameter.indexOf(61);
                if (-1 == assignmentDelimiterIndex) continue;
                String parameterName = queryParameter.substring(0, assignmentDelimiterIndex);
                String parameterValue = queryParameter.substring(assignmentDelimiterIndex + 1);
                result.put(parameterName, parameterValue);
            }
            return result;
        }
    }

    @Immutable
    static final class MongoDbUriEnhancer
    implements Function<URI, String> {
        private final Map<String, Object> extraUriOptions;

        private MongoDbUriEnhancer(Map<String, Object> extraUriOptions) {
            this.extraUriOptions = extraUriOptions;
        }

        static MongoDbUriEnhancer of(Map<String, Object> extraUriOptions) {
            ConditionChecker.checkNotNull(extraUriOptions, (String)"The MongoDB extraUriOptions config must not be null!");
            return new MongoDbUriEnhancer(extraUriOptions);
        }

        @Override
        @Nullable
        public String apply(URI mongoDBUri) {
            ConditionChecker.checkNotNull((Object)mongoDBUri, (String)"The MongoDB URI must not be null!");
            return MongoDbUriEnhancer.getEncodedQueryString(this.putMongoDbConnectionOptions(MongoDbUriEnhancer.parseQueryComponent(mongoDBUri.getQuery())));
        }

        private static Map<String, String> parseQueryComponent(@Nullable String originalUriQueryComponent) {
            QueryComponentParser queryComponentParser = QueryComponentParser.getInstance();
            return queryComponentParser.apply(originalUriQueryComponent);
        }

        private Map<String, String> putMongoDbConnectionOptions(Map<String, String> queryParameters) {
            for (Map.Entry<String, Object> connectionOptionEntry : this.extraUriOptions.entrySet()) {
                queryParameters.put(connectionOptionEntry.getKey(), String.valueOf(connectionOptionEntry.getValue()));
            }
            return queryParameters;
        }

        @Nullable
        private static String getEncodedQueryString(Map<String, String> query) {
            if (query.isEmpty()) {
                return null;
            }
            return query.entrySet().stream().map(MongoDbUriEnhancer::getEncodeQueryParameterString).collect(Collectors.joining("&"));
        }

        private static String getEncodeQueryParameterString(Map.Entry<String, String> entry) {
            String encodedParameterName = MongoDbUriEnhancer.encodeWithUtf8(entry.getKey());
            String encodedParameterValue = MongoDbUriEnhancer.encodeWithUtf8(entry.getValue());
            return String.format("%s=%s", encodedParameterName, encodedParameterValue);
        }

        private static String encodeWithUtf8(String s) {
            return URLEncoder.encode(s, StandardCharsets.UTF_8);
        }
    }
}

