/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.base.model.common.ConditionChecker;

public enum ReadConcern {
    DEFAULT("default", com.mongodb.ReadConcern.DEFAULT),
    LOCAL("local", com.mongodb.ReadConcern.LOCAL),
    MAJORITY("majority", com.mongodb.ReadConcern.MAJORITY),
    LINEARIZABLE("linearizable", com.mongodb.ReadConcern.LINEARIZABLE),
    SNAPSHOT("snapshot", com.mongodb.ReadConcern.SNAPSHOT),
    AVAILABLE("available", com.mongodb.ReadConcern.AVAILABLE);

    private final String name;
    private final com.mongodb.ReadConcern mongoReadConcern;

    private ReadConcern(String name, com.mongodb.ReadConcern mongoReadConcern) {
        this.name = name;
        this.mongoReadConcern = mongoReadConcern;
    }

    public com.mongodb.ReadConcern getMongoReadConcern() {
        return this.mongoReadConcern;
    }

    static Optional<ReadConcern> ofReadConcern(String readConcern) {
        ConditionChecker.checkNotNull((Object)readConcern, (String)"readConcern");
        return Arrays.stream(ReadConcern.values()).filter(c -> c.name.contentEquals(readConcern)).findFirst();
    }
}

