/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.config;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.base.model.common.ConditionChecker;

public enum ReadPreference {
    PRIMARY("primary", com.mongodb.ReadPreference.primary()),
    PRIMARY_PREFERRED("primaryPreferred", com.mongodb.ReadPreference.primaryPreferred()),
    SECONDARY("secondary", com.mongodb.ReadPreference.secondary()),
    SECONDARY_PREFERRED("secondaryPreferred", com.mongodb.ReadPreference.secondaryPreferred()),
    NEAREST("nearest", com.mongodb.ReadPreference.nearest());

    private final String name;
    private final com.mongodb.ReadPreference mongoReadPreference;

    private ReadPreference(String name, com.mongodb.ReadPreference mongoReadPreference) {
        this.name = name;
        this.mongoReadPreference = mongoReadPreference;
    }

    public com.mongodb.ReadPreference getMongoReadPreference() {
        return this.mongoReadPreference;
    }

    static Optional<ReadPreference> ofReadPreference(String readPreference) {
        ConditionChecker.checkNotNull((Object)readPreference, (String)"readPreference");
        return Arrays.stream(ReadPreference.values()).filter(c -> c.name.contentEquals(readPreference)).findFirst();
    }
}

