/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.indices;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonInt32;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.IndexDirection;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.IndexKey;

@Immutable
public final class DefaultIndexKey
implements IndexKey {
    private final String fieldName;
    private final IndexDirection direction;

    private DefaultIndexKey(String fieldName, IndexDirection direction) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.direction = Objects.requireNonNull(direction);
    }

    public static DefaultIndexKey of(String fieldName) {
        return new DefaultIndexKey(fieldName, IndexDirection.DEFAULT);
    }

    public static DefaultIndexKey of(String fieldName, IndexDirection direction) {
        return new DefaultIndexKey(fieldName, direction);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public BsonInt32 getBsonValue() {
        return this.direction.getBsonInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIndexKey that = (DefaultIndexKey)o;
        return Objects.equals(this.fieldName, that.fieldName) && this.direction == that.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.direction});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [fieldName='" + this.fieldName + "', direction=" + this.direction + "]";
    }
}

