/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.indices;

import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.ditto.internal.utils.persistence.mongo.BsonUtil;

public final class Index {
    private final BsonDocument keys;
    private final String name;
    private final boolean unique;
    private final boolean sparse;
    private final boolean background;
    private final BsonDocument partialFilterExpression;
    @Nullable
    private final Long expireAfterSeconds;

    private Index(BsonDocument keys, String name, boolean unique, boolean sparse, boolean background, BsonDocument partialFilterExpression, @Nullable Long expireAfterSeconds) {
        this.keys = Objects.requireNonNull(keys);
        this.name = Objects.requireNonNull(name);
        this.unique = unique;
        this.sparse = sparse;
        this.background = background;
        this.expireAfterSeconds = expireAfterSeconds;
        this.partialFilterExpression = partialFilterExpression;
    }

    static Index of(BsonDocument keys, String name, boolean unique, boolean sparse, boolean background) {
        return new Index(keys, name, unique, sparse, background, new BsonDocument(), null);
    }

    public static Index indexInfoOf(Document document) {
        Objects.requireNonNull(document);
        BsonDocument keyDbObject = BsonUtil.toBsonDocument((Bson)((Document)document.get((Object)"key")));
        String name = document.get((Object)"name").toString();
        boolean unique = (Boolean)document.get((Object)"unique", (Object)false);
        boolean sparse = (Boolean)document.get((Object)"sparse", (Object)false);
        boolean background = (Boolean)document.get((Object)"background", (Object)false);
        Object expireAfterSecondsObject = document.get((Object)"expireAfterSeconds");
        Long expireAfterSeconds = expireAfterSecondsObject != null ? Long.valueOf(((Number)expireAfterSecondsObject).longValue()) : null;
        String partialFilterExpressionName = "partialFilterExpression";
        BsonDocument partialFilterExpression = document.containsKey((Object)"partialFilterExpression") ? BsonUtil.toBsonDocument((Bson)((Document)document.get((Object)"partialFilterExpression"))) : new BsonDocument();
        return new Index(keyDbObject, name, unique, sparse, background, partialFilterExpression, expireAfterSeconds);
    }

    public Index withExpireAfterSeconds(long expireAfterSeconds) {
        return new Index(this.keys, this.name, this.unique, this.sparse, this.background, this.partialFilterExpression, expireAfterSeconds);
    }

    public Index withPartialFilterExpression(BsonDocument partialFilterExpression) {
        return new Index(this.keys, this.name, this.unique, this.sparse, this.background, partialFilterExpression, this.expireAfterSeconds);
    }

    public IndexModel toIndexModel() {
        IndexOptions options = new IndexOptions().name(this.name).unique(this.unique).sparse(this.sparse).background(this.background);
        if (!this.partialFilterExpression.isEmpty()) {
            options.partialFilterExpression((Bson)this.partialFilterExpression);
        }
        this.getExpireAfterSeconds().ifPresent(n -> options.expireAfter(n, TimeUnit.SECONDS));
        return new IndexModel((Bson)this.keys, options);
    }

    public BsonDocument getKeys() {
        return this.keys;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isBackground() {
        return this.background;
    }

    public Optional<Long> getExpireAfterSeconds() {
        return Optional.ofNullable(this.expireAfterSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index indexInfo = (Index)o;
        return this.unique == indexInfo.unique && this.sparse == indexInfo.sparse && this.background == indexInfo.background && Objects.equals(this.keys, indexInfo.keys) && Objects.equals(this.name, indexInfo.name) && Objects.equals(this.partialFilterExpression, indexInfo.partialFilterExpression) && Objects.equals(this.expireAfterSeconds, indexInfo.expireAfterSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.name, this.unique, this.sparse, this.background, this.partialFilterExpression, this.expireAfterSeconds);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [keys=" + this.keys + ", name='" + this.name + "', unique=" + this.unique + ", sparse=" + this.sparse + ", background=" + this.background + ", partialFilterExpression=" + this.partialFilterExpression + ", expireAfterSeconds=" + this.expireAfterSeconds + "]";
    }
}

