/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.indices;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonDocument;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.DefaultIndexKey;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.Index;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.IndexKey;

@Immutable
public final class IndexFactory {
    private static final boolean BACKGROUND_OPTION_DEFAULT = true;

    private IndexFactory() {
        throw new AssertionError();
    }

    public static Index newInstance(String name, List<String> fields, boolean unique) {
        List<IndexKey> keys = IndexFactory.createDefaultKeys(Objects.requireNonNull(fields));
        return IndexFactory.newInstanceWithCustomKeys(name, keys, unique);
    }

    public static Index newInstance(String name, List<String> fields, boolean unique, boolean sparse) {
        BsonDocument keys = IndexFactory.createKeysDocument(IndexFactory.createDefaultKeys(Objects.requireNonNull(fields)));
        return Index.of(keys, name, unique, sparse, true);
    }

    public static Index newInstanceWithCustomKeys(String name, List<IndexKey> keys, boolean unique) {
        BsonDocument keysDocument = IndexFactory.createKeysDocument(Objects.requireNonNull(keys));
        return Index.of(keysDocument, name, unique, unique, true);
    }

    public static Index newExpirationIndex(String name, String field, long expireAfterSeconds) {
        DefaultIndexKey key = DefaultIndexKey.of(field);
        BsonDocument keysDocument = IndexFactory.createKeysDocument(Collections.singletonList(key));
        return Index.of(keysDocument, name, false, true, true).withExpireAfterSeconds(expireAfterSeconds);
    }

    private static BsonDocument createKeysDocument(List<IndexKey> keys) {
        BsonDocument keysDocument = new BsonDocument();
        for (IndexKey key : keys) {
            keysDocument.append(key.getFieldName(), key.getBsonValue());
        }
        return keysDocument;
    }

    private static List<IndexKey> createDefaultKeys(List<String> fieldNames) {
        return fieldNames.stream().map(DefaultIndexKey::of).collect(Collectors.toList());
    }
}

