/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.indices;

import akka.Done;
import akka.NotUsed;
import akka.japi.function.Function;
import akka.japi.function.Function2;
import akka.japi.pf.PFBuilder;
import akka.stream.javadsl.Source;
import com.mongodb.MongoCommandException;
import com.mongodb.client.model.IndexModel;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.bson.Document;
import org.eclipse.ditto.internal.utils.persistence.mongo.indices.Index;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

@Immutable
public final class IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexOperations.class);
    private static final String DEFAULT_INDEX_NAME = "_id_";
    private final MongoDatabase db;

    private IndexOperations(MongoDatabase db) {
        this.db = db;
    }

    public static IndexOperations of(MongoDatabase db) {
        Objects.requireNonNull(db);
        return new IndexOperations(db);
    }

    public Source<Done, NotUsed> dropIndex(String collectionName, String indexName) {
        return Source.fromPublisher((Publisher)this.getCollection(collectionName).dropIndex(indexName)).map((Function & Serializable)nullValue -> Done.done()).recoverWith(IndexOperations.buildDropIndexRecovery(indexName));
    }

    public Source<Done, NotUsed> createIndex(String collectionName, Index index) {
        IndexModel indexModel = index.toIndexModel();
        return Source.fromPublisher((Publisher)this.getCollection(collectionName).createIndex(indexModel.getKeys(), indexModel.getOptions())).map((Function & Serializable)unused -> Done.done());
    }

    public Source<List<Index>, NotUsed> getIndices(String collectionName) {
        return Source.fromPublisher((Publisher)this.getCollection(collectionName).listIndexes()).map(Index::indexInfoOf).fold(new ArrayList(), (Function2 & Serializable)(aggregate, element) -> {
            aggregate.add(element);
            return aggregate;
        });
    }

    public Source<List<Index>, NotUsed> getIndicesExceptDefaultIndex(String collectionName) {
        return this.getIndices(collectionName).map((Function & Serializable)indices -> indices.stream().filter(indexInfo -> !DEFAULT_INDEX_NAME.equals(indexInfo.getName())).collect(Collectors.toList()));
    }

    private MongoCollection<Document> getCollection(String collectionName) {
        return this.db.getCollection(collectionName);
    }

    private static PartialFunction<Throwable, Source<Done, NotUsed>> buildDropIndexRecovery(String indexDescription) {
        return new PFBuilder().match(MongoCommandException.class, IndexOperations::isIndexNotFound, throwable -> {
            LOGGER.debug("Index <{}> could not be dropped because it does not exist (anymore).", (Object)indexDescription);
            return Source.single((Object)Done.done());
        }).build();
    }

    private static boolean isIndexNotFound(MongoCommandException e) {
        return e.getErrorCode() == 27;
    }
}

