/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.monitoring;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.concurrent.TimeUnit;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.metrics.DittoMetrics;
import org.eclipse.ditto.internal.utils.metrics.instruments.timer.PreparedTimer;
import org.eclipse.ditto.internal.utils.tracing.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KamonCommandListener
implements CommandListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(KamonCommandListener.class);
    private static final String COMMAND_NAME_TAG = "command_name";
    private final String timerName;

    public KamonCommandListener(String metricName) {
        this.timerName = (String)ConditionChecker.argumentNotEmpty((CharSequence)metricName, (String)"metricName") + "_mongodb";
    }

    public void commandStarted(CommandStartedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sent command '{}:{}' with id {} to database '{}' on connection '{}' to server '{}'", new Object[]{event.getCommandName(), event.getCommand().get((Object)event.getCommandName()), event.getRequestId(), event.getDatabaseName(), event.getConnectionDescription().getConnectionId(), event.getConnectionDescription().getServerAddress()});
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully executed command '{}' with id {} on connection '{}' to server '{}' after {}ms", new Object[]{event.getCommandName(), event.getRequestId(), event.getConnectionDescription().getConnectionId(), event.getConnectionDescription().getServerAddress(), event.getElapsedTime(TimeUnit.MILLISECONDS)});
        }
        long elapsedTime = event.getElapsedTime(TimeUnit.NANOSECONDS);
        String commandName = event.getCommandName();
        this.recordElapsedTime(elapsedTime, commandName);
    }

    public void commandFailed(CommandFailedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Failed execution of command '{}' with id {} on connection '{}' to server '{}'  after {}ms with exception '{}'", new Object[]{event.getCommandName(), event.getRequestId(), event.getConnectionDescription().getConnectionId(), event.getConnectionDescription().getServerAddress(), event.getElapsedTime(TimeUnit.MILLISECONDS), event.getThrowable()});
        }
        long elapsedTime = event.getElapsedTime(TimeUnit.NANOSECONDS);
        String commandName = event.getCommandName();
        this.recordElapsedTime(elapsedTime, commandName);
    }

    private void recordElapsedTime(long elapsedTime, String commandName) {
        ((PreparedTimer)DittoMetrics.timer((String)TraceUtils.metricizeTraceUri((String)this.timerName)).tag(COMMAND_NAME_TAG, commandName)).record(elapsedTime, TimeUnit.NANOSECONDS);
    }
}

