/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.monitoring;

import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.ditto.internal.utils.metrics.DittoMetrics;
import org.eclipse.ditto.internal.utils.metrics.instruments.gauge.Gauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KamonConnectionPoolListener
implements ConnectionPoolListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(KamonConnectionPoolListener.class);
    private final ConcurrentMap<ServerId, PoolMetric> metrics = new ConcurrentHashMap<ServerId, PoolMetric>();
    private final String metricName;

    public KamonConnectionPoolListener(String metricName) {
        this.metricName = metricName;
    }

    public void connectionPoolCreated(ConnectionPoolCreatedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection pool opened: {}", (Object)event);
        }
        PoolMetric metric = new PoolMetric(event.getServerId());
        this.metrics.put(event.getServerId(), metric);
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection pool closed: {}", (Object)event);
        }
        this.metrics.remove(event.getServerId());
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.metrics.compute(event.getConnectionId().getServerId(), (serverId, metric) -> metric.incCheckedOutCount());
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.metrics.compute(event.getConnectionId().getServerId(), (serverId, metric) -> metric.decCheckedOutCount());
    }

    public void connectionCreated(ConnectionCreatedEvent event) {
        this.metrics.compute(event.getConnectionId().getServerId(), (serverId, metric) -> metric.incPoolSize());
    }

    public void connectionClosed(ConnectionClosedEvent event) {
        this.metrics.compute(event.getConnectionId().getServerId(), (serverId, metric) -> metric.decPoolSize());
    }

    private class PoolMetric {
        private static final String POOL_PREFIX = "_pool";
        private static final String CHECKED_OUT_COUNT = "_checkedOutCount";
        private static final String POOL_SIZE = "_poolSize";
        private static final String CLUSTER_ID_TAG = "cluster_id";
        private final Gauge poolSizeGauge;
        private final Gauge checkOutCountGauge;

        private PoolMetric(ServerId serverId) {
            String clusterId = serverId.getClusterId().getValue();
            this.poolSizeGauge = (Gauge)DittoMetrics.gauge((String)(KamonConnectionPoolListener.this.metricName + "_pool_poolSize")).tag(CLUSTER_ID_TAG, clusterId);
            this.poolSizeGauge.set(Long.valueOf(0L));
            this.checkOutCountGauge = (Gauge)DittoMetrics.gauge((String)(KamonConnectionPoolListener.this.metricName + "_pool_checkedOutCount")).tag(CLUSTER_ID_TAG, clusterId);
            this.checkOutCountGauge.set(Long.valueOf(0L));
        }

        private PoolMetric incPoolSize() {
            this.poolSizeGauge.increment();
            return this;
        }

        private PoolMetric decPoolSize() {
            this.poolSizeGauge.decrement();
            return this;
        }

        private PoolMetric incCheckedOutCount() {
            this.checkOutCountGauge.increment();
            return this;
        }

        private PoolMetric decCheckedOutCount() {
            this.checkOutCountGauge.decrement();
            return this;
        }
    }
}

