/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.japi.pf.PFBuilder;
import akka.stream.javadsl.Source;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.persistence.mongo.BsonUtil;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoOpsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoOpsUtil.class);
    private static final int RETRY_ATTEMPTS = 0;

    private MongoOpsUtil() {
        throw new AssertionError();
    }

    public static Source<List<Throwable>, NotUsed> drop(MongoCollection<Document> collection) {
        return MongoOpsUtil.doDrop((MongoCollection<Document>)((MongoCollection)ConditionChecker.checkNotNull(collection, (String)"collection"))).map((Function & Serializable)opt -> opt.map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    public static Source<List<Throwable>, NotUsed> deleteByFilter(MongoCollection<Document> collection, Bson filter) {
        return MongoOpsUtil.doDeleteByFilter((MongoCollection<Document>)((MongoCollection)ConditionChecker.checkNotNull(collection, (String)"collection")), (Bson)ConditionChecker.checkNotNull((Object)filter, (String)"filter ")).map((Function & Serializable)opt -> opt.map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private static Source<Optional<Throwable>, NotUsed> doDrop(MongoCollection<Document> collection) {
        return Source.fromPublisher((Publisher)collection.drop()).map((Function & Serializable)result -> {
            LOGGER.debug("Successfully dropped collection <{}>.", (Object)collection.getNamespace());
            return Optional.empty();
        }).recoverWithRetries(0, new PFBuilder().matchAny(throwable -> Source.single(Optional.of(throwable))).build());
    }

    private static Source<Optional<Throwable>, NotUsed> doDeleteByFilter(MongoCollection<Document> collection, Bson filter) {
        List<DeleteManyModel> writeModel = Collections.singletonList(new DeleteManyModel(filter));
        BulkWriteOptions options = new BulkWriteOptions().ordered(false);
        return Source.fromPublisher((Publisher)collection.bulkWrite(writeModel, options)).map((Function & Serializable)result -> {
            if (LOGGER.isDebugEnabled()) {
                BsonDocument filterBsonDoc = BsonUtil.toBsonDocument(filter);
                LOGGER.debug("Deleted <{}> documents from collection <{}>. Filter was <{}>.", new Object[]{result.getDeletedCount(), collection.getNamespace(), filterBsonDoc});
            }
            return Optional.empty();
        }).recoverWithRetries(0, new PFBuilder().matchAny(throwable -> Source.single(Optional.of(throwable))).build());
    }
}

