/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.MongoOpsUtil;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoEventSourceSettings;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoPersistenceOperationsSelection;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoPersistenceOperationsSelectionProvider;
import org.eclipse.ditto.internal.utils.persistence.operations.EntityPersistenceOperations;

public final class MongoEntitiesPersistenceOperations
implements EntityPersistenceOperations {
    private final MongoDatabase db;
    private final MongoPersistenceOperationsSelectionProvider selectionProvider;

    private MongoEntitiesPersistenceOperations(MongoDatabase db, MongoEventSourceSettings eventSourceSettings) {
        this.db = Objects.requireNonNull(db);
        Objects.requireNonNull(eventSourceSettings);
        this.selectionProvider = MongoPersistenceOperationsSelectionProvider.of(eventSourceSettings);
    }

    public static MongoEntitiesPersistenceOperations of(MongoDatabase db, MongoEventSourceSettings eventSourceSettings) {
        return new MongoEntitiesPersistenceOperations(db, eventSourceSettings);
    }

    @Override
    public Source<List<Throwable>, NotUsed> purgeEntity(EntityId entityId) {
        Objects.requireNonNull(entityId);
        Collection<MongoPersistenceOperationsSelection> selections = this.selectEntity(entityId);
        return this.purgeAllSelections(selections);
    }

    private Collection<MongoPersistenceOperationsSelection> selectEntity(EntityId entityId) {
        return this.selectionProvider.selectEntity(entityId);
    }

    private Source<List<Throwable>, NotUsed> purgeAllSelections(Collection<MongoPersistenceOperationsSelection> selections) {
        Source result = Source.empty();
        for (MongoPersistenceOperationsSelection mongoOpsSelection : selections) {
            Source<List<Throwable>, NotUsed> purge = this.purge(mongoOpsSelection);
            result = result.merge(purge);
        }
        return result;
    }

    private Source<List<Throwable>, NotUsed> purge(MongoPersistenceOperationsSelection selection) {
        MongoCollection collection = this.db.getCollection(selection.getCollectionName());
        return MongoOpsUtil.deleteByFilter((MongoCollection<Document>)collection, (Bson)selection.getFilter());
    }
}

