/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;

@Immutable
public final class MongoEventSourceSettings {
    private final String persistenceIdPrefix;
    private final String metadataCollectionName;
    private final String journalCollectionName;
    private final String snapshotCollectionName;
    private final boolean supportsNamespaces;

    private MongoEventSourceSettings(String persistenceIdPrefix, boolean supportsNamespaces, String metadataCollectionName, String journalCollectionName, String snapshotCollectionName) {
        this.persistenceIdPrefix = (String)ConditionChecker.checkNotNull((Object)persistenceIdPrefix, (String)"persistence ID prefix");
        this.supportsNamespaces = supportsNamespaces;
        this.metadataCollectionName = (String)ConditionChecker.checkNotNull((Object)metadataCollectionName, (String)"metadata collection name");
        this.journalCollectionName = (String)ConditionChecker.checkNotNull((Object)journalCollectionName, (String)"journal collection name");
        this.snapshotCollectionName = (String)ConditionChecker.checkNotNull((Object)snapshotCollectionName, (String)"snapshot collection name");
    }

    public static MongoEventSourceSettings of(String persistenceIdPrefix, boolean supportsNamespaces, String metadataCollectionName, String journalCollectionName, String snapshotCollectionName) {
        return new MongoEventSourceSettings(persistenceIdPrefix, supportsNamespaces, metadataCollectionName, journalCollectionName, snapshotCollectionName);
    }

    public static MongoEventSourceSettings fromConfig(Config config, String persistenceIdPrefix, boolean supportsNamespaces, String journalPluginId, String snapshotPluginId) {
        ConditionChecker.checkNotNull((Object)config, (String)"config");
        ConditionChecker.checkNotNull((Object)journalPluginId, (String)"journal plugin ID");
        ConditionChecker.checkNotNull((Object)snapshotPluginId, (String)"snapshot plugin ID");
        String metadataCollectionName = MongoEventSourceSettings.getCollectionName(config, journalPluginId, "metadata");
        String journalCollectionName = MongoEventSourceSettings.getCollectionName(config, journalPluginId, "journal");
        String snapshotCollectionName = MongoEventSourceSettings.getCollectionName(config, snapshotPluginId, "snaps");
        return new MongoEventSourceSettings(persistenceIdPrefix, supportsNamespaces, metadataCollectionName, journalCollectionName, snapshotCollectionName);
    }

    public String getPersistenceIdPrefix() {
        return this.persistenceIdPrefix;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public String getJournalCollectionName() {
        return this.journalCollectionName;
    }

    public String getSnapshotCollectionName() {
        return this.snapshotCollectionName;
    }

    public boolean isSupportsNamespaces() {
        return this.supportsNamespaces;
    }

    private static String getCollectionName(Config config, String root, String collectionType) {
        return config.getString(String.format("%s.overrides.%s-collection", root, collectionType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoEventSourceSettings that = (MongoEventSourceSettings)o;
        return this.supportsNamespaces == that.supportsNamespaces && Objects.equals(this.persistenceIdPrefix, that.persistenceIdPrefix) && Objects.equals(this.metadataCollectionName, that.metadataCollectionName) && Objects.equals(this.journalCollectionName, that.journalCollectionName) && Objects.equals(this.snapshotCollectionName, that.snapshotCollectionName);
    }

    public int hashCode() {
        return Objects.hash(this.persistenceIdPrefix, this.metadataCollectionName, this.journalCollectionName, this.snapshotCollectionName, this.supportsNamespaces);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [persistenceIdPrefix='" + this.persistenceIdPrefix + "', metadataCollectionName='" + this.metadataCollectionName + "', journalCollectionName='" + this.journalCollectionName + "', snapshotCollectionName='" + this.snapshotCollectionName + "', supportsNamespaces=" + this.supportsNamespaces + "]";
    }
}

